/*
 *  linux/fs/ufs/file.c
 *
 * Copyright (C) 1998
 * Daniel Pirkl <daniel.pirkl@email.cz>
 * Charles University, Faculty of Mathematics and Physics
 *
 *  from
 *
 *  linux/fs/ext2/file.c
 *
 * Copyright (C) 1992, 1993, 1994, 1995
 * Remy Card (card@masi.ibp.fr)
 * Laboratoire MASI - Institut Blaise Pascal
 * Universite Pierre et Marie Curie (Paris VI)
 *
 *  from
 *
 *  linux/fs/minix/file.c
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 *
 *  ext2 fs regular file handling primitives
 */

#include <linux/fs.h>
#include <linux/ufs_fs.h>
#include <linux/buffer_head.h>	/* for sync_mapping_buffers() */

static int ufs_sync_file(struct file *file, struct dentry *dentry, int datasync)
{
	struct inode *inode = dentry->d_inode;
	int err;
	int ret;

	ret = sync_mapping_buffers(inode->i_mapping);
	if (!(inode->i_state & I_DIRTY))
		return ret;
	if (datasync && !(inode->i_state & I_DIRTY_DATASYNC))
		return ret;

	err = ufs_sync_inode(inode);
	if (ret == 0)
		ret = err;
	return ret;
}


/*
 * We have mostly NULL's here: the current defaults are ok for
 * the ufs filesystem.
 */
 
const struct file_operations ufs_file_operations = {
	.llseek		= generic_file_llseek,
	.read		= generic_file_read,
	.write		= generic_file_write,
	.mmap		= generic_file_mmap,
	.open           = generic_file_open,
	.fsync		= ufs_sync_file,
	.sendfile	= generic_file_sendfile,
};

struct inode_operations ufs_file_inode_operations = {
	.truncate	= ufs_truncate,
};
