/*
 * NET4:	Sysctl interface to net af_unix subsystem.
 *
 * Authors:	Mike Shaver.
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */

#include <linux/mm.h>
#include <linux/sysctl.h>

#include <net/af_unix.h>

static ctl_table unix_table[] = {
	{
		.ctl_name	= NET_UNIX_MAX_DGRAM_QLEN,
		.procname	= "max_dgram_qlen",
		.data		= &init_net.sysctl_unix_max_dgram_qlen,
		.maxlen		= sizeof(int),
		.mode		= 0644,
		.proc_handler	= &proc_dointvec
	},
	{ .ctl_name = 0 }
};

static struct ctl_path unix_path[] = {
	{ .procname = "net", .ctl_name = CTL_NET, },
	{ .procname = "unix", .ctl_name = NET_UNIX, },
	{ },
};

int unix_sysctl_register(struct net *net)
{
	struct ctl_table *table;

	table = kmemdup(unix_table, sizeof(unix_table), GFP_KERNEL);
	if (table == NULL)
		goto err_alloc;

	table[0].data = &net->sysctl_unix_max_dgram_qlen;
	net->unix_ctl = register_net_sysctl_table(net, unix_path, table);
	if (net->unix_ctl == NULL)
		goto err_reg;

	return 0;

err_reg:
	kfree(table);
err_alloc:
	return -ENOMEM;
}

void unix_sysctl_unregister(struct net *net)
{
	struct ctl_table *table;

	table = net->unix_ctl->ctl_table_arg;
	unregister_sysctl_table(net->unix_ctl);
	kfree(table);
}

