/*
 * OMAP44xx ES1.0 pin mux definition
 *
 * Copyright (C) 2010 Texas Instruments, Inc.
 *
 * Benoit Cousson (b-cousson@ti.com)
 *
 * - Based on mux34xx.c done by Tony Lindgren <tony@atomide.com>
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#include <linux/module.h>
#include <linux/init.h>

#include "mux.h"

#ifdef CONFIG_OMAP_MUX

#define _OMAP4_MUXENTRY(M0, g, m0, m1, m2, m3, m4, m5, m6, m7)	\
{									\
	.reg_offset	= (OMAP4_CTRL_MODULE_PAD_##M0##_OFFSET),	\
	.gpio		= (g),						\
	.muxnames	= { m0, m1, m2, m3, m4, m5, m6, m7 },		\
}

#else

#define _OMAP4_MUXENTRY(M0, g, m0, m1, m2, m3, m4, m5, m6, m7)	\
{									\
	.reg_offset	= (OMAP4_CTRL_MODULE_PAD_##M0##_OFFSET),	\
	.gpio		= (g),						\
}

#endif

#define _OMAP4_BALLENTRY(M0, bb, bt)				\
{									\
	.reg_offset	= (OMAP4_CTRL_MODULE_PAD_##M0##_OFFSET),	\
	.balls		= { bb, bt },					\
}

/*
 * Superset of all mux modes for omap4 ES1.0
 */
static struct omap_mux __initdata omap4_core_muxmodes[] = {
	_OMAP4_MUXENTRY(GPMC_AD0, 0, "gpmc_ad0", "sdmmc2_dat0", NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD1, 0, "gpmc_ad1", "sdmmc2_dat1", NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD2, 0, "gpmc_ad2", "sdmmc2_dat2", NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD3, 0, "gpmc_ad3", "sdmmc2_dat3", NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD4, 0, "gpmc_ad4", "sdmmc2_dat4",
			"sdmmc2_dir_dat0", NULL, NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD5, 0, "gpmc_ad5", "sdmmc2_dat5",
			"sdmmc2_dir_dat1", NULL, NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD6, 0, "gpmc_ad6", "sdmmc2_dat6",
			"sdmmc2_dir_cmd", NULL, NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD7, 0, "gpmc_ad7", "sdmmc2_dat7",
			"sdmmc2_clk_fdbk", NULL, NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD8, 32, "gpmc_ad8", "kpd_row0", "c2c_data15",
			"gpio_32", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD9, 33, "gpmc_ad9", "kpd_row1", "c2c_data14",
			"gpio_33", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD10, 34, "gpmc_ad10", "kpd_row2", "c2c_data13",
			"gpio_34", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD11, 35, "gpmc_ad11", "kpd_row3", "c2c_data12",
			"gpio_35", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD12, 36, "gpmc_ad12", "kpd_col0", "c2c_data11",
			"gpio_36", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD13, 37, "gpmc_ad13", "kpd_col1", "c2c_data10",
			"gpio_37", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD14, 38, "gpmc_ad14", "kpd_col2", "c2c_data9",
			"gpio_38", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD15, 39, "gpmc_ad15", "kpd_col3", "c2c_data8",
			"gpio_39", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_A16, 40, "gpmc_a16", "kpd_row4", "c2c_datain0",
			"gpio_40", "venc_656_data0", NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_A17, 41, "gpmc_a17", "kpd_row5", "c2c_datain1",
			"gpio_41", "venc_656_data1", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A18, 42, "gpmc_a18", "kpd_row6", "c2c_datain2",
			"gpio_42", "venc_656_data2", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A19, 43, "gpmc_a19", "kpd_row7", "c2c_datain3",
			"gpio_43", "venc_656_data3", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A20, 44, "gpmc_a20", "kpd_col4", "c2c_datain4",
			"gpio_44", "venc_656_data4", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A21, 45, "gpmc_a21", "kpd_col5", "c2c_datain5",
			"gpio_45", "venc_656_data5", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A22, 46, "gpmc_a22", "kpd_col6", "c2c_datain6",
			"gpio_46", "venc_656_data6", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A23, 47, "gpmc_a23", "kpd_col7", "c2c_datain7",
			"gpio_47", "venc_656_data7", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A24, 48, "gpmc_a24", NULL, "c2c_clkout0",
			"gpio_48", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A25, 49, "gpmc_a25", NULL, "c2c_clkout1",
			"gpio_49", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_NCS0, 50, "gpmc_ncs0", NULL, NULL, "gpio_50",
			"sys_ndmareq0", NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_NCS1, 51, "gpmc_ncs1", NULL, "c2c_dataout6",
			"gpio_51", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_NCS2, 52, "gpmc_ncs2", NULL, "c2c_dataout7",
			"gpio_52", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_NCS3, 53, "gpmc_ncs3", "gpmc_dir",
			"c2c_dataout4", "gpio_53", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(GPMC_NWP, 54, "gpmc_nwp", "dsi1_te0", NULL, "gpio_54",
			"sys_ndmareq1", NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_CLK, 55, "gpmc_clk", NULL, NULL, "gpio_55",
			"sys_ndmareq2", NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_NADV_ALE, 56, "gpmc_nadv_ale", "dsi1_te1", NULL,
			"gpio_56", "sys_ndmareq3", NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_NOE, 0, "gpmc_noe", "sdmmc2_clk", NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_NWE, 0, "gpmc_nwe", "sdmmc2_cmd", NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_NBE0_CLE, 59, "gpmc_nbe0_cle", "dsi2_te0", NULL,
			"gpio_59", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_NBE1, 60, "gpmc_nbe1", NULL, "c2c_dataout5",
			"gpio_60", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_WAIT0, 61, "gpmc_wait0", "dsi2_te1", NULL,
			"gpio_61", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_WAIT1, 62, "gpmc_wait1", NULL, "c2c_dataout2",
			"gpio_62", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(C2C_DATA11, 100, "c2c_data11", "usbc1_icusb_txen",
			"c2c_dataout3", "gpio_100", "sys_ndmareq0", NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(C2C_DATA12, 101, "c2c_data12", "dsi1_te0",
			"c2c_clkin0", "gpio_101", "sys_ndmareq1", NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(C2C_DATA13, 102, "c2c_data13", "dsi1_te1",
			"c2c_clkin1", "gpio_102", "sys_ndmareq2", NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(C2C_DATA14, 103, "c2c_data14", "dsi2_te0",
			"c2c_dataout0", "gpio_103", "sys_ndmareq3", NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(C2C_DATA15, 104, "c2c_data15", "dsi2_te1",
			"c2c_dataout1", "gpio_104", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(HDMI_HPD, 63, "hdmi_hpd", NULL, NULL, "gpio_63", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(HDMI_CEC, 64, "hdmi_cec", NULL, NULL, "gpio_64", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(HDMI_DDC_SCL, 65, "hdmi_ddc_scl", NULL, NULL,
			"gpio_65", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(HDMI_DDC_SDA, 66, "hdmi_ddc_sda", NULL, NULL,
			"gpio_66", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DX0, 0, "csi21_dx0", NULL, NULL, "gpi_67", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DY0, 0, "csi21_dy0", NULL, NULL, "gpi_68", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DX1, 0, "csi21_dx1", NULL, NULL, "gpi_69", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DY1, 0, "csi21_dy1", NULL, NULL, "gpi_70", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DX2, 0, "csi21_dx2", NULL, NULL, "gpi_71", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DY2, 0, "csi21_dy2", NULL, NULL, "gpi_72", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DX3, 0, "csi21_dx3", NULL, NULL, "gpi_73", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DY3, 0, "csi21_dy3", NULL, NULL, "gpi_74", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DX4, 0, "csi21_dx4", NULL, NULL, "gpi_75", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DY4, 0, "csi21_dy4", NULL, NULL, "gpi_76", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI22_DX0, 0, "csi22_dx0", NULL, NULL, "gpi_77", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI22_DY0, 0, "csi22_dy0", NULL, NULL, "gpi_78", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI22_DX1, 0, "csi22_dx1", NULL, NULL, "gpi_79", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI22_DY1, 0, "csi22_dy1", NULL, NULL, "gpi_80", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CAM_SHUTTER, 81, "cam_shutter", NULL, NULL, "gpio_81",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CAM_STROBE, 82, "cam_strobe", NULL, NULL, "gpio_82",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CAM_GLOBALRESET, 83, "cam_globalreset", NULL, NULL,
			"gpio_83", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_CLK, 84, "usbb1_ulpitll_clk",
			"hsi1_cawake", NULL, "gpio_84", "usbb1_ulpiphy_clk",
			NULL, "hw_dbg20", "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_STP, 85, "usbb1_ulpitll_stp",
			"hsi1_cadata", "mcbsp4_clkr", "gpio_85",
			"usbb1_ulpiphy_stp", "usbb1_mm_rxdp", "hw_dbg21",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DIR, 86, "usbb1_ulpitll_dir",
			"hsi1_caflag", "mcbsp4_fsr", "gpio_86",
			"usbb1_ulpiphy_dir", NULL, "hw_dbg22", "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_NXT, 87, "usbb1_ulpitll_nxt",
			"hsi1_acready", "mcbsp4_fsx", "gpio_87",
			"usbb1_ulpiphy_nxt", "usbb1_mm_rxdm", "hw_dbg23",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT0, 88, "usbb1_ulpitll_dat0",
			"hsi1_acwake", "mcbsp4_clkx", "gpio_88",
			"usbb1_ulpiphy_dat0", "usbb1_mm_rxrcv", "hw_dbg24",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT1, 89, "usbb1_ulpitll_dat1",
			"hsi1_acdata", "mcbsp4_dx", "gpio_89",
			"usbb1_ulpiphy_dat1", "usbb1_mm_txse0", "hw_dbg25",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT2, 90, "usbb1_ulpitll_dat2",
			"hsi1_acflag", "mcbsp4_dr", "gpio_90",
			"usbb1_ulpiphy_dat2", "usbb1_mm_txdat", "hw_dbg26",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT3, 91, "usbb1_ulpitll_dat3",
			"hsi1_caready", NULL, "gpio_91", "usbb1_ulpiphy_dat3",
			"usbb1_mm_txen", "hw_dbg27", "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT4, 92, "usbb1_ulpitll_dat4",
			"dmtimer8_pwm_evt", "abe_mcbsp3_dr", "gpio_92",
			"usbb1_ulpiphy_dat4", NULL, "hw_dbg28", "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT5, 93, "usbb1_ulpitll_dat5",
			"dmtimer9_pwm_evt", "abe_mcbsp3_dx", "gpio_93",
			"usbb1_ulpiphy_dat5", NULL, "hw_dbg29", "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT6, 94, "usbb1_ulpitll_dat6",
			"dmtimer10_pwm_evt", "abe_mcbsp3_clkx", "gpio_94",
			"usbb1_ulpiphy_dat6", "abe_dmic_din3", "hw_dbg30",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT7, 95, "usbb1_ulpitll_dat7",
			"dmtimer11_pwm_evt", "abe_mcbsp3_fsx", "gpio_95",
			"usbb1_ulpiphy_dat7", "abe_dmic_clk3", "hw_dbg31",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_HSIC_DATA, 96, "usbb1_hsic_data", NULL, NULL,
			"gpio_96", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_HSIC_STROBE, 97, "usbb1_hsic_strobe", NULL,
			NULL, "gpio_97", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBC1_ICUSB_DP, 98, "usbc1_icusb_dp", NULL, NULL,
			"gpio_98", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBC1_ICUSB_DM, 99, "usbc1_icusb_dm", NULL, NULL,
			"gpio_99", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_CLK, 100, "sdmmc1_clk", NULL, "dpm_emu19",
			"gpio_100", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_CMD, 101, "sdmmc1_cmd", NULL, "uart1_rx",
			"gpio_101", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT0, 102, "sdmmc1_dat0", NULL, "dpm_emu18",
			"gpio_102", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT1, 103, "sdmmc1_dat1", NULL, "dpm_emu17",
			"gpio_103", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT2, 104, "sdmmc1_dat2", NULL, "dpm_emu16",
			"gpio_104", "jtag_tms_tmsc", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT3, 105, "sdmmc1_dat3", NULL, "dpm_emu15",
			"gpio_105", "jtag_tck", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT4, 106, "sdmmc1_dat4", NULL, NULL,
			"gpio_106", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT5, 107, "sdmmc1_dat5", NULL, NULL,
			"gpio_107", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT6, 108, "sdmmc1_dat6", NULL, NULL,
			"gpio_108", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT7, 109, "sdmmc1_dat7", NULL, NULL,
			"gpio_109", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP2_CLKX, 110, "abe_mcbsp2_clkx", "mcspi2_clk",
			"abe_mcasp_ahclkx", "gpio_110", "usbb2_mm_rxdm",
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP2_DR, 111, "abe_mcbsp2_dr", "mcspi2_somi",
			"abe_mcasp_axr", "gpio_111", "usbb2_mm_rxdp", NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP2_DX, 112, "abe_mcbsp2_dx", "mcspi2_simo",
			"abe_mcasp_amute", "gpio_112", "usbb2_mm_rxrcv", NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP2_FSX, 113, "abe_mcbsp2_fsx", "mcspi2_cs0",
			"abe_mcasp_afsx", "gpio_113", "usbb2_mm_txen", NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP1_CLKX, 114, "abe_mcbsp1_clkx",
			"abe_slimbus1_clock", NULL, "gpio_114", NULL, NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP1_DR, 115, "abe_mcbsp1_dr",
			"abe_slimbus1_data", NULL, "gpio_115", NULL, NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP1_DX, 116, "abe_mcbsp1_dx", "sdmmc3_dat2",
			"abe_mcasp_aclkx", "gpio_116", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP1_FSX, 117, "abe_mcbsp1_fsx", "sdmmc3_dat3",
			"abe_mcasp_amutein", "gpio_117", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(ABE_PDM_UL_DATA, 0, "abe_pdm_ul_data",
			"abe_mcbsp3_dr", NULL, NULL, NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(ABE_PDM_DL_DATA, 0, "abe_pdm_dl_data",
			"abe_mcbsp3_dx", NULL, NULL, NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(ABE_PDM_FRAME, 0, "abe_pdm_frame", "abe_mcbsp3_clkx",
			NULL, NULL, NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_PDM_LB_CLK, 0, "abe_pdm_lb_clk", "abe_mcbsp3_fsx",
			NULL, NULL, NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_CLKS, 118, "abe_clks", NULL, NULL, "gpio_118",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_DMIC_CLK1, 119, "abe_dmic_clk1", NULL, NULL,
			"gpio_119", "usbb2_mm_txse0", NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(ABE_DMIC_DIN1, 120, "abe_dmic_din1", NULL, NULL,
			"gpio_120", "usbb2_mm_txdat", NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(ABE_DMIC_DIN2, 121, "abe_dmic_din2", "slimbus2_clock",
			NULL, "gpio_121", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_DMIC_DIN3, 122, "abe_dmic_din3", "slimbus2_data",
			"abe_dmic_clk2", "gpio_122", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(UART2_CTS, 123, "uart2_cts", "sdmmc3_clk", NULL,
			"gpio_123", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART2_RTS, 124, "uart2_rts", "sdmmc3_cmd", NULL,
			"gpio_124", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART2_RX, 125, "uart2_rx", "sdmmc3_dat0", NULL,
			"gpio_125", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART2_TX, 126, "uart2_tx", "sdmmc3_dat1", NULL,
			"gpio_126", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(HDQ_SIO, 127, "hdq_sio", "i2c3_sccb", "i2c2_sccb",
			"gpio_127", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(I2C1_SCL, 0, "i2c1_scl", NULL, NULL, NULL, NULL, NULL,
			NULL, NULL),
	_OMAP4_MUXENTRY(I2C1_SDA, 0, "i2c1_sda", NULL, NULL, NULL, NULL, NULL,
			NULL, NULL),
	_OMAP4_MUXENTRY(I2C2_SCL, 128, "i2c2_scl", "uart1_rx", NULL,
			"gpio_128", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(I2C2_SDA, 129, "i2c2_sda", "uart1_tx", NULL,
			"gpio_129", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(I2C3_SCL, 130, "i2c3_scl", NULL, NULL, "gpio_130",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(I2C3_SDA, 131, "i2c3_sda", NULL, NULL, "gpio_131",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(I2C4_SCL, 132, "i2c4_scl", NULL, NULL, "gpio_132",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(I2C4_SDA, 133, "i2c4_sda", NULL, NULL, "gpio_133",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_CLK, 134, "mcspi1_clk", NULL, NULL, "gpio_134",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_SOMI, 135, "mcspi1_somi", NULL, NULL,
			"gpio_135", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_SIMO, 136, "mcspi1_simo", NULL, NULL,
			"gpio_136", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_CS0, 137, "mcspi1_cs0", NULL, NULL, "gpio_137",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_CS1, 138, "mcspi1_cs1", "uart1_rx", NULL,
			"gpio_138", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_CS2, 139, "mcspi1_cs2", "uart1_cts",
			"slimbus2_clock", "gpio_139", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_CS3, 140, "mcspi1_cs3", "uart1_rts",
			"slimbus2_data", "gpio_140", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(UART3_CTS_RCTX, 141, "uart3_cts_rctx", "uart1_tx",
			NULL, "gpio_141", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART3_RTS_SD, 142, "uart3_rts_sd", NULL, NULL,
			"gpio_142", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART3_RX_IRRX, 143, "uart3_rx_irrx",
			"dmtimer8_pwm_evt", NULL, "gpio_143", NULL, NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART3_TX_IRTX, 144, "uart3_tx_irtx",
			"dmtimer9_pwm_evt", NULL, "gpio_144", NULL, NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC5_CLK, 145, "sdmmc5_clk", "mcspi2_clk",
			"usbc1_icusb_dp", "gpio_145", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(SDMMC5_CMD, 146, "sdmmc5_cmd", "mcspi2_simo",
			"usbc1_icusb_dm", "gpio_146", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(SDMMC5_DAT0, 147, "sdmmc5_dat0", "mcspi2_somi",
			"usbc1_icusb_rcv", "gpio_147", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(SDMMC5_DAT1, 148, "sdmmc5_dat1", NULL,
			"usbc1_icusb_txen", "gpio_148", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(SDMMC5_DAT2, 149, "sdmmc5_dat2", "mcspi2_cs1", NULL,
			"gpio_149", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC5_DAT3, 150, "sdmmc5_dat3", "mcspi2_cs0", NULL,
			"gpio_150", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI4_CLK, 151, "mcspi4_clk", "sdmmc4_clk", NULL,
			"gpio_151", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI4_SIMO, 152, "mcspi4_simo", "sdmmc4_cmd", NULL,
			"gpio_152", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI4_SOMI, 153, "mcspi4_somi", "sdmmc4_dat0", NULL,
			"gpio_153", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI4_CS0, 154, "mcspi4_cs0", "sdmmc4_dat3", NULL,
			"gpio_154", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART4_RX, 155, "uart4_rx", "sdmmc4_dat2", NULL,
			"gpio_155", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART4_TX, 156, "uart4_tx", "sdmmc4_dat1", NULL,
			"gpio_156", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_CLK, 157, "usbb2_ulpitll_clk",
			"usbb2_ulpiphy_clk", "sdmmc4_cmd", "gpio_157",
			"hsi2_cawake", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_STP, 158, "usbb2_ulpitll_stp",
			"usbb2_ulpiphy_stp", "sdmmc4_clk", "gpio_158",
			"hsi2_cadata", "dispc2_data23", NULL, "reserved"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DIR, 159, "usbb2_ulpitll_dir",
			"usbb2_ulpiphy_dir", "sdmmc4_dat0", "gpio_159",
			"hsi2_caflag", "dispc2_data22", NULL, "reserved"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_NXT, 160, "usbb2_ulpitll_nxt",
			"usbb2_ulpiphy_nxt", "sdmmc4_dat1", "gpio_160",
			"hsi2_acready", "dispc2_data21", NULL, "reserved"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT0, 161, "usbb2_ulpitll_dat0",
			"usbb2_ulpiphy_dat0", "sdmmc4_dat2", "gpio_161",
			"hsi2_acwake", "dispc2_data20", NULL, "reserved"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT1, 162, "usbb2_ulpitll_dat1",
			"usbb2_ulpiphy_dat1", "sdmmc4_dat3", "gpio_162",
			"hsi2_acdata", "dispc2_data19", NULL, "reserved"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT2, 163, "usbb2_ulpitll_dat2",
			"usbb2_ulpiphy_dat2", "sdmmc3_dat2", "gpio_163",
			"hsi2_acflag", "dispc2_data18", NULL, "reserved"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT3, 164, "usbb2_ulpitll_dat3",
			"usbb2_ulpiphy_dat3", "sdmmc3_dat1", "gpio_164",
			"hsi2_caready", "dispc2_data15", NULL, "reserved"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT4, 165, "usbb2_ulpitll_dat4",
			"usbb2_ulpiphy_dat4", "sdmmc3_dat0", "gpio_165",
			"mcspi3_somi", "dispc2_data14", NULL, "reserved"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT5, 166, "usbb2_ulpitll_dat5",
			"usbb2_ulpiphy_dat5", "sdmmc3_dat3", "gpio_166",
			"mcspi3_cs0", "dispc2_data13", NULL, "reserved"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT6, 167, "usbb2_ulpitll_dat6",
			"usbb2_ulpiphy_dat6", "sdmmc3_cmd", "gpio_167",
			"mcspi3_simo", "dispc2_data12", NULL, "reserved"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT7, 168, "usbb2_ulpitll_dat7",
			"usbb2_ulpiphy_dat7", "sdmmc3_clk", "gpio_168",
			"mcspi3_clk", "dispc2_data11", NULL, "reserved"),
	_OMAP4_MUXENTRY(USBB2_HSIC_DATA, 169, "usbb2_hsic_data", NULL, NULL,
			"gpio_169", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBB2_HSIC_STROBE, 170, "usbb2_hsic_strobe", NULL,
			NULL, "gpio_170", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UNIPRO_TX0, 171, "unipro_tx0", "kpd_col0", NULL,
			"gpio_171", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UNIPRO_TY0, 172, "unipro_ty0", "kpd_col1", NULL,
			"gpio_172", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UNIPRO_TX1, 173, "unipro_tx1", "kpd_col2", NULL,
			"gpio_173", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UNIPRO_TY1, 174, "unipro_ty1", "kpd_col3", NULL,
			"gpio_174", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UNIPRO_TX2, 0, "unipro_tx2", "kpd_col4", NULL,
			"gpio_0", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UNIPRO_TY2, 1, "unipro_ty2", "kpd_col5", NULL,
			"gpio_1", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UNIPRO_RX0, 0, "unipro_rx0", "kpd_row0", NULL,
			"gpi_175", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UNIPRO_RY0, 0, "unipro_ry0", "kpd_row1", NULL,
			"gpi_176", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UNIPRO_RX1, 0, "unipro_rx1", "kpd_row2", NULL,
			"gpi_177", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UNIPRO_RY1, 0, "unipro_ry1", "kpd_row3", NULL,
			"gpi_178", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UNIPRO_RX2, 0, "unipro_rx2", "kpd_row4", NULL,
			"gpi_2", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UNIPRO_RY2, 0, "unipro_ry2", "kpd_row5", NULL,
			"gpi_3", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBA0_OTG_CE, 0, "usba0_otg_ce", NULL, NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(USBA0_OTG_DP, 179, "usba0_otg_dp", "uart3_rx_irrx",
			"uart2_rx", "gpio_179", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(USBA0_OTG_DM, 180, "usba0_otg_dm", "uart3_tx_irtx",
			"uart2_tx", "gpio_180", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(FREF_CLK1_OUT, 181, "fref_clk1_out", NULL, NULL,
			"gpio_181", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(FREF_CLK2_OUT, 182, "fref_clk2_out", NULL, NULL,
			"gpio_182", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_NIRQ1, 0, "sys_nirq1", NULL, NULL, NULL, NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_NIRQ2, 183, "sys_nirq2", NULL, NULL, "gpio_183",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_BOOT0, 184, "sys_boot0", NULL, NULL, "gpio_184",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_BOOT1, 185, "sys_boot1", NULL, NULL, "gpio_185",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_BOOT2, 186, "sys_boot2", NULL, NULL, "gpio_186",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_BOOT3, 187, "sys_boot3", NULL, NULL, "gpio_187",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_BOOT4, 188, "sys_boot4", NULL, NULL, "gpio_188",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_BOOT5, 189, "sys_boot5", NULL, NULL, "gpio_189",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU0, 11, "dpm_emu0", NULL, NULL, "gpio_11", NULL,
			NULL, "hw_dbg0", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU1, 12, "dpm_emu1", NULL, NULL, "gpio_12", NULL,
			NULL, "hw_dbg1", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU2, 13, "dpm_emu2", "usba0_ulpiphy_clk", NULL,
			"gpio_13", NULL, "dispc2_fid", "hw_dbg2", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU3, 14, "dpm_emu3", "usba0_ulpiphy_stp", NULL,
			"gpio_14", NULL, "dispc2_data10", "hw_dbg3",
			"reserved"),
	_OMAP4_MUXENTRY(DPM_EMU4, 15, "dpm_emu4", "usba0_ulpiphy_dir", NULL,
			"gpio_15", NULL, "dispc2_data9", "hw_dbg4",
			"reserved"),
	_OMAP4_MUXENTRY(DPM_EMU5, 16, "dpm_emu5", "usba0_ulpiphy_nxt", NULL,
			"gpio_16", "rfbi_te_vsync0", "dispc2_data16",
			"hw_dbg5", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU6, 17, "dpm_emu6", "usba0_ulpiphy_dat0",
			"uart3_tx_irtx", "gpio_17", "rfbi_hsync0",
			"dispc2_data17", "hw_dbg6", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU7, 18, "dpm_emu7", "usba0_ulpiphy_dat1",
			"uart3_rx_irrx", "gpio_18", "rfbi_cs0",
			"dispc2_hsync", "hw_dbg7", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU8, 19, "dpm_emu8", "usba0_ulpiphy_dat2",
			"uart3_rts_sd", "gpio_19", "rfbi_re", "dispc2_pclk",
			"hw_dbg8", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU9, 20, "dpm_emu9", "usba0_ulpiphy_dat3",
			"uart3_cts_rctx", "gpio_20", "rfbi_we",
			"dispc2_vsync", "hw_dbg9", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU10, 21, "dpm_emu10", "usba0_ulpiphy_dat4",
			NULL, "gpio_21", "rfbi_a0", "dispc2_de", "hw_dbg10",
			"reserved"),
	_OMAP4_MUXENTRY(DPM_EMU11, 22, "dpm_emu11", "usba0_ulpiphy_dat5",
			NULL, "gpio_22", "rfbi_data8", "dispc2_data8",
			"hw_dbg11", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU12, 23, "dpm_emu12", "usba0_ulpiphy_dat6",
			NULL, "gpio_23", "rfbi_data7", "dispc2_data7",
			"hw_dbg12", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU13, 24, "dpm_emu13", "usba0_ulpiphy_dat7",
			NULL, "gpio_24", "rfbi_data6", "dispc2_data6",
			"hw_dbg13", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU14, 25, "dpm_emu14", "sys_drm_msecure",
			"uart1_rx", "gpio_25", "rfbi_data5", "dispc2_data5",
			"hw_dbg14", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU15, 26, "dpm_emu15", "sys_secure_indicator",
			NULL, "gpio_26", "rfbi_data4", "dispc2_data4",
			"hw_dbg15", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU16, 27, "dpm_emu16", "dmtimer8_pwm_evt",
			"dsi1_te0", "gpio_27", "rfbi_data3", "dispc2_data3",
			"hw_dbg16", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU17, 28, "dpm_emu17", "dmtimer9_pwm_evt",
			"dsi1_te1", "gpio_28", "rfbi_data2", "dispc2_data2",
			"hw_dbg17", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU18, 190, "dpm_emu18", "dmtimer10_pwm_evt",
			"dsi2_te0", "gpio_190", "rfbi_data1", "dispc2_data1",
			"hw_dbg18", "reserved"),
	_OMAP4_MUXENTRY(DPM_EMU19, 191, "dpm_emu19", "dmtimer11_pwm_evt",
			"dsi2_te1", "gpio_191", "rfbi_data0", "dispc2_data0",
			"hw_dbg19", "reserved"),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};

/*
 * Balls for 44XX CBL package
 * 547-pin CBL ES1.0 S-FPGA-N547, 0.40mm Ball Pitch (Top),
 *				  0.40mm Ball Pitch (Bottom)
 */
#if defined(CONFIG_OMAP_MUX) && defined(CONFIG_DEBUG_FS)		\
		&& defined(CONFIG_OMAP_PACKAGE_CBL)
struct omap_ball __initdata omap4_core_cbl_ball[] = {
	_OMAP4_BALLENTRY(GPMC_AD0, "c12", NULL),
	_OMAP4_BALLENTRY(GPMC_AD1, "d12", NULL),
	_OMAP4_BALLENTRY(GPMC_AD2, "c13", NULL),
	_OMAP4_BALLENTRY(GPMC_AD3, "d13", NULL),
	_OMAP4_BALLENTRY(GPMC_AD4, "c15", NULL),
	_OMAP4_BALLENTRY(GPMC_AD5, "d15", NULL),
	_OMAP4_BALLENTRY(GPMC_AD6, "a16", NULL),
	_OMAP4_BALLENTRY(GPMC_AD7, "b16", NULL),
	_OMAP4_BALLENTRY(GPMC_AD8, "c16", NULL),
	_OMAP4_BALLENTRY(GPMC_AD9, "d16", NULL),
	_OMAP4_BALLENTRY(GPMC_AD10, "c17", NULL),
	_OMAP4_BALLENTRY(GPMC_AD11, "d17", NULL),
	_OMAP4_BALLENTRY(GPMC_AD12, "c18", NULL),
	_OMAP4_BALLENTRY(GPMC_AD13, "d18", NULL),
	_OMAP4_BALLENTRY(GPMC_AD14, "c19", NULL),
	_OMAP4_BALLENTRY(GPMC_AD15, "d19", NULL),
	_OMAP4_BALLENTRY(GPMC_A16, "b17", NULL),
	_OMAP4_BALLENTRY(GPMC_A17, "a18", NULL),
	_OMAP4_BALLENTRY(GPMC_A18, "b18", NULL),
	_OMAP4_BALLENTRY(GPMC_A19, "a19", NULL),
	_OMAP4_BALLENTRY(GPMC_A20, "b19", NULL),
	_OMAP4_BALLENTRY(GPMC_A21, "b20", NULL),
	_OMAP4_BALLENTRY(GPMC_A22, "a21", NULL),
	_OMAP4_BALLENTRY(GPMC_A23, "b21", NULL),
	_OMAP4_BALLENTRY(GPMC_A24, "c20", NULL),
	_OMAP4_BALLENTRY(GPMC_A25, "d20", NULL),
	_OMAP4_BALLENTRY(GPMC_NCS0, "b25", NULL),
	_OMAP4_BALLENTRY(GPMC_NCS1, "c21", NULL),
	_OMAP4_BALLENTRY(GPMC_NCS2, "d21", NULL),
	_OMAP4_BALLENTRY(GPMC_NCS3, "c22", NULL),
	_OMAP4_BALLENTRY(GPMC_NWP, "c25", NULL),
	_OMAP4_BALLENTRY(GPMC_CLK, "b22", NULL),
	_OMAP4_BALLENTRY(GPMC_NADV_ALE, "d25", NULL),
	_OMAP4_BALLENTRY(GPMC_NOE, "b11", NULL),
	_OMAP4_BALLENTRY(GPMC_NWE, "b12", NULL),
	_OMAP4_BALLENTRY(GPMC_NBE0_CLE, "c23", NULL),
	_OMAP4_BALLENTRY(GPMC_NBE1, "d22", NULL),
	_OMAP4_BALLENTRY(GPMC_WAIT0, "b26", NULL),
	_OMAP4_BALLENTRY(GPMC_WAIT1, "b23", NULL),
	_OMAP4_BALLENTRY(C2C_DATA11, "d23", NULL),
	_OMAP4_BALLENTRY(C2C_DATA12, "a24", NULL),
	_OMAP4_BALLENTRY(C2C_DATA13, "b24", NULL),
	_OMAP4_BALLENTRY(C2C_DATA14, "c24", NULL),
	_OMAP4_BALLENTRY(C2C_DATA15, "d24", NULL),
	_OMAP4_BALLENTRY(HDMI_HPD, "b9", NULL),
	_OMAP4_BALLENTRY(HDMI_CEC, "b10", NULL),
	_OMAP4_BALLENTRY(HDMI_DDC_SCL, "a8", NULL),
	_OMAP4_BALLENTRY(HDMI_DDC_SDA, "b8", NULL),
	_OMAP4_BALLENTRY(CSI21_DX0, "r26", NULL),
	_OMAP4_BALLENTRY(CSI21_DY0, "r25", NULL),
	_OMAP4_BALLENTRY(CSI21_DX1, "t26", NULL),
	_OMAP4_BALLENTRY(CSI21_DY1, "t25", NULL),
	_OMAP4_BALLENTRY(CSI21_DX2, "u26", NULL),
	_OMAP4_BALLENTRY(CSI21_DY2, "u25", NULL),
	_OMAP4_BALLENTRY(CSI21_DX3, "v26", NULL),
	_OMAP4_BALLENTRY(CSI21_DY3, "v25", NULL),
	_OMAP4_BALLENTRY(CSI21_DX4, "w26", NULL),
	_OMAP4_BALLENTRY(CSI21_DY4, "w25", NULL),
	_OMAP4_BALLENTRY(CSI22_DX0, "m26", NULL),
	_OMAP4_BALLENTRY(CSI22_DY0, "m25", NULL),
	_OMAP4_BALLENTRY(CSI22_DX1, "n26", NULL),
	_OMAP4_BALLENTRY(CSI22_DY1, "n25", NULL),
	_OMAP4_BALLENTRY(CAM_SHUTTER, "t27", NULL),
	_OMAP4_BALLENTRY(CAM_STROBE, "u27", NULL),
	_OMAP4_BALLENTRY(CAM_GLOBALRESET, "v27", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_CLK, "ae18", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_STP, "ag19", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DIR, "af19", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_NXT, "ae19", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT0, "af18", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT1, "ag18", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT2, "ae17", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT3, "af17", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT4, "ah17", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT5, "ae16", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT6, "af16", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT7, "ag16", NULL),
	_OMAP4_BALLENTRY(USBB1_HSIC_DATA, "af14", NULL),
	_OMAP4_BALLENTRY(USBB1_HSIC_STROBE, "ae14", NULL),
	_OMAP4_BALLENTRY(USBC1_ICUSB_DP, "h2", NULL),
	_OMAP4_BALLENTRY(USBC1_ICUSB_DM, "h3", NULL),
	_OMAP4_BALLENTRY(SDMMC1_CLK, "d2", NULL),
	_OMAP4_BALLENTRY(SDMMC1_CMD, "e3", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT0, "e4", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT1, "e2", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT2, "e1", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT3, "f4", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT4, "f3", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT5, "f1", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT6, "g4", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT7, "g3", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP2_CLKX, "ad27", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP2_DR, "ad26", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP2_DX, "ad25", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP2_FSX, "ac28", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP1_CLKX, "ac26", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP1_DR, "ac25", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP1_DX, "ab25", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP1_FSX, "ac27", NULL),
	_OMAP4_BALLENTRY(ABE_PDM_UL_DATA, "ag25", NULL),
	_OMAP4_BALLENTRY(ABE_PDM_DL_DATA, "af25", NULL),
	_OMAP4_BALLENTRY(ABE_PDM_FRAME, "ae25", NULL),
	_OMAP4_BALLENTRY(ABE_PDM_LB_CLK, "af26", NULL),
	_OMAP4_BALLENTRY(ABE_CLKS, "ah26", NULL),
	_OMAP4_BALLENTRY(ABE_DMIC_CLK1, "ae24", NULL),
	_OMAP4_BALLENTRY(ABE_DMIC_DIN1, "af24", NULL),
	_OMAP4_BALLENTRY(ABE_DMIC_DIN2, "ag24", NULL),
	_OMAP4_BALLENTRY(ABE_DMIC_DIN3, "ah24", NULL),
	_OMAP4_BALLENTRY(UART2_CTS, "ab26", NULL),
	_OMAP4_BALLENTRY(UART2_RTS, "ab27", NULL),
	_OMAP4_BALLENTRY(UART2_RX, "aa25", NULL),
	_OMAP4_BALLENTRY(UART2_TX, "aa26", NULL),
	_OMAP4_BALLENTRY(HDQ_SIO, "aa27", NULL),
	_OMAP4_BALLENTRY(I2C1_SCL, "ae28", NULL),
	_OMAP4_BALLENTRY(I2C1_SDA, "ae26", NULL),
	_OMAP4_BALLENTRY(I2C2_SCL, "c26", NULL),
	_OMAP4_BALLENTRY(I2C2_SDA, "d26", NULL),
	_OMAP4_BALLENTRY(I2C3_SCL, "w27", NULL),
	_OMAP4_BALLENTRY(I2C3_SDA, "y27", NULL),
	_OMAP4_BALLENTRY(I2C4_SCL, "ag21", NULL),
	_OMAP4_BALLENTRY(I2C4_SDA, "ah22", NULL),
	_OMAP4_BALLENTRY(MCSPI1_CLK, "af22", NULL),
	_OMAP4_BALLENTRY(MCSPI1_SOMI, "ae22", NULL),
	_OMAP4_BALLENTRY(MCSPI1_SIMO, "ag22", NULL),
	_OMAP4_BALLENTRY(MCSPI1_CS0, "ae23", NULL),
	_OMAP4_BALLENTRY(MCSPI1_CS1, "af23", NULL),
	_OMAP4_BALLENTRY(MCSPI1_CS2, "ag23", NULL),
	_OMAP4_BALLENTRY(MCSPI1_CS3, "ah23", NULL),
	_OMAP4_BALLENTRY(UART3_CTS_RCTX, "f27", NULL),
	_OMAP4_BALLENTRY(UART3_RTS_SD, "f28", NULL),
	_OMAP4_BALLENTRY(UART3_RX_IRRX, "g27", NULL),
	_OMAP4_BALLENTRY(UART3_TX_IRTX, "g28", NULL),
	_OMAP4_BALLENTRY(SDMMC5_CLK, "ae5", NULL),
	_OMAP4_BALLENTRY(SDMMC5_CMD, "af5", NULL),
	_OMAP4_BALLENTRY(SDMMC5_DAT0, "ae4", NULL),
	_OMAP4_BALLENTRY(SDMMC5_DAT1, "af4", NULL),
	_OMAP4_BALLENTRY(SDMMC5_DAT2, "ag3", NULL),
	_OMAP4_BALLENTRY(SDMMC5_DAT3, "af3", NULL),
	_OMAP4_BALLENTRY(MCSPI4_CLK, "ae21", NULL),
	_OMAP4_BALLENTRY(MCSPI4_SIMO, "af20", NULL),
	_OMAP4_BALLENTRY(MCSPI4_SOMI, "af21", NULL),
	_OMAP4_BALLENTRY(MCSPI4_CS0, "ae20", NULL),
	_OMAP4_BALLENTRY(UART4_RX, "ag20", NULL),
	_OMAP4_BALLENTRY(UART4_TX, "ah19", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_CLK, "ag12", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_STP, "af12", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DIR, "ae12", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_NXT, "ag13", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT0, "ae11", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT1, "af11", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT2, "ag11", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT3, "ah11", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT4, "ae10", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT5, "af10", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT6, "ag10", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT7, "ae9", NULL),
	_OMAP4_BALLENTRY(USBB2_HSIC_DATA, "af13", NULL),
	_OMAP4_BALLENTRY(USBB2_HSIC_STROBE, "ae13", NULL),
	_OMAP4_BALLENTRY(UNIPRO_TX0, "g26", NULL),
	_OMAP4_BALLENTRY(UNIPRO_TY0, "g25", NULL),
	_OMAP4_BALLENTRY(UNIPRO_TX1, "h26", NULL),
	_OMAP4_BALLENTRY(UNIPRO_TY1, "h25", NULL),
	_OMAP4_BALLENTRY(UNIPRO_TX2, "j27", NULL),
	_OMAP4_BALLENTRY(UNIPRO_TY2, "h27", NULL),
	_OMAP4_BALLENTRY(UNIPRO_RX0, "j26", NULL),
	_OMAP4_BALLENTRY(UNIPRO_RY0, "j25", NULL),
	_OMAP4_BALLENTRY(UNIPRO_RX1, "k26", NULL),
	_OMAP4_BALLENTRY(UNIPRO_RY1, "k25", NULL),
	_OMAP4_BALLENTRY(UNIPRO_RX2, "l27", NULL),
	_OMAP4_BALLENTRY(UNIPRO_RY2, "k27", NULL),
	_OMAP4_BALLENTRY(USBA0_OTG_CE, "c3", NULL),
	_OMAP4_BALLENTRY(USBA0_OTG_DP, "b5", NULL),
	_OMAP4_BALLENTRY(USBA0_OTG_DM, "b4", NULL),
	_OMAP4_BALLENTRY(FREF_CLK1_OUT, "aa28", NULL),
	_OMAP4_BALLENTRY(FREF_CLK2_OUT, "y28", NULL),
	_OMAP4_BALLENTRY(SYS_NIRQ1, "ae6", NULL),
	_OMAP4_BALLENTRY(SYS_NIRQ2, "af6", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT0, "f26", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT1, "e27", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT2, "e26", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT3, "e25", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT4, "d28", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT5, "d27", NULL),
	_OMAP4_BALLENTRY(DPM_EMU0, "m2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU1, "n2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU2, "p2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU3, "v1", NULL),
	_OMAP4_BALLENTRY(DPM_EMU4, "v2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU5, "w1", NULL),
	_OMAP4_BALLENTRY(DPM_EMU6, "w2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU7, "w3", NULL),
	_OMAP4_BALLENTRY(DPM_EMU8, "w4", NULL),
	_OMAP4_BALLENTRY(DPM_EMU9, "y2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU10, "y3", NULL),
	_OMAP4_BALLENTRY(DPM_EMU11, "y4", NULL),
	_OMAP4_BALLENTRY(DPM_EMU12, "aa1", NULL),
	_OMAP4_BALLENTRY(DPM_EMU13, "aa2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU14, "aa3", NULL),
	_OMAP4_BALLENTRY(DPM_EMU15, "aa4", NULL),
	_OMAP4_BALLENTRY(DPM_EMU16, "ab2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU17, "ab3", NULL),
	_OMAP4_BALLENTRY(DPM_EMU18, "ab4", NULL),
	_OMAP4_BALLENTRY(DPM_EMU19, "ac4", NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#else
#define omap4_core_cbl_ball  NULL
#endif

/*
 * Superset of all mux modes for omap4 ES2.0
 */
static struct omap_mux __initdata omap4_es2_core_muxmodes[] = {
	_OMAP4_MUXENTRY(GPMC_AD0, 0, "gpmc_ad0", "sdmmc2_dat0", NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD1, 0, "gpmc_ad1", "sdmmc2_dat1", NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD2, 0, "gpmc_ad2", "sdmmc2_dat2", NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD3, 0, "gpmc_ad3", "sdmmc2_dat3", NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD4, 0, "gpmc_ad4", "sdmmc2_dat4",
			"sdmmc2_dir_dat0", NULL, NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD5, 0, "gpmc_ad5", "sdmmc2_dat5",
			"sdmmc2_dir_dat1", NULL, NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD6, 0, "gpmc_ad6", "sdmmc2_dat6",
			"sdmmc2_dir_cmd", NULL, NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD7, 0, "gpmc_ad7", "sdmmc2_dat7",
			"sdmmc2_clk_fdbk", NULL, NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD8, 32, "gpmc_ad8", "kpd_row0", "c2c_data15",
			"gpio_32", NULL, "sdmmc1_dat0", NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD9, 33, "gpmc_ad9", "kpd_row1", "c2c_data14",
			"gpio_33", NULL, "sdmmc1_dat1", NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD10, 34, "gpmc_ad10", "kpd_row2", "c2c_data13",
			"gpio_34", NULL, "sdmmc1_dat2", NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD11, 35, "gpmc_ad11", "kpd_row3", "c2c_data12",
			"gpio_35", NULL, "sdmmc1_dat3", NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD12, 36, "gpmc_ad12", "kpd_col0", "c2c_data11",
			"gpio_36", NULL, "sdmmc1_dat4", NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD13, 37, "gpmc_ad13", "kpd_col1", "c2c_data10",
			"gpio_37", NULL, "sdmmc1_dat5", NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD14, 38, "gpmc_ad14", "kpd_col2", "c2c_data9",
			"gpio_38", NULL, "sdmmc1_dat6", NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_AD15, 39, "gpmc_ad15", "kpd_col3", "c2c_data8",
			"gpio_39", NULL, "sdmmc1_dat7", NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_A16, 40, "gpmc_a16", "kpd_row4", "c2c_datain0",
			"gpio_40", "venc_656_data0", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A17, 41, "gpmc_a17", "kpd_row5", "c2c_datain1",
			"gpio_41", "venc_656_data1", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A18, 42, "gpmc_a18", "kpd_row6", "c2c_datain2",
			"gpio_42", "venc_656_data2", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A19, 43, "gpmc_a19", "kpd_row7", "c2c_datain3",
			"gpio_43", "venc_656_data3", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A20, 44, "gpmc_a20", "kpd_col4", "c2c_datain4",
			"gpio_44", "venc_656_data4", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A21, 45, "gpmc_a21", "kpd_col5", "c2c_datain5",
			"gpio_45", "venc_656_data5", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A22, 46, "gpmc_a22", "kpd_col6", "c2c_datain6",
			"gpio_46", "venc_656_data6", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A23, 47, "gpmc_a23", "kpd_col7", "c2c_datain7",
			"gpio_47", "venc_656_data7", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A24, 48, "gpmc_a24", "kpd_col8", "c2c_clkout0",
			"gpio_48", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_A25, 49, "gpmc_a25", NULL, "c2c_clkout1",
			"gpio_49", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_NCS0, 50, "gpmc_ncs0", NULL, NULL, "gpio_50",
			"sys_ndmareq0", NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_NCS1, 51, "gpmc_ncs1", NULL, "c2c_dataout6",
			"gpio_51", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_NCS2, 52, "gpmc_ncs2", "kpd_row8",
			"c2c_dataout7", "gpio_52", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(GPMC_NCS3, 53, "gpmc_ncs3", "gpmc_dir",
			"c2c_dataout4", "gpio_53", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(GPMC_NWP, 54, "gpmc_nwp", "dsi1_te0", NULL, "gpio_54",
			"sys_ndmareq1", NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_CLK, 55, "gpmc_clk", NULL, NULL, "gpio_55",
			"sys_ndmareq2", "sdmmc1_cmd", NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_NADV_ALE, 56, "gpmc_nadv_ale", "dsi1_te1", NULL,
			"gpio_56", "sys_ndmareq3", "sdmmc1_clk", NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_NOE, 0, "gpmc_noe", "sdmmc2_clk", NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_NWE, 0, "gpmc_nwe", "sdmmc2_cmd", NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_NBE0_CLE, 59, "gpmc_nbe0_cle", "dsi2_te0", NULL,
			"gpio_59", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_NBE1, 60, "gpmc_nbe1", NULL, "c2c_dataout5",
			"gpio_60", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_WAIT0, 61, "gpmc_wait0", "dsi2_te1", NULL,
			"gpio_61", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(GPMC_WAIT1, 62, "gpmc_wait1", NULL, "c2c_dataout2",
			"gpio_62", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_WAIT2, 100, "gpmc_wait2", "usbc1_icusb_txen",
			"c2c_dataout3", "gpio_100", "sys_ndmareq0", NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_NCS4, 101, "gpmc_ncs4", "dsi1_te0", "c2c_clkin0",
			"gpio_101", "sys_ndmareq1", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_NCS5, 102, "gpmc_ncs5", "dsi1_te1", "c2c_clkin1",
			"gpio_102", "sys_ndmareq2", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_NCS6, 103, "gpmc_ncs6", "dsi2_te0",
			"c2c_dataout0", "gpio_103", "sys_ndmareq3", NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(GPMC_NCS7, 104, "gpmc_ncs7", "dsi2_te1",
			"c2c_dataout1", "gpio_104", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(HDMI_HPD, 63, "hdmi_hpd", NULL, NULL, "gpio_63", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(HDMI_CEC, 64, "hdmi_cec", NULL, NULL, "gpio_64", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(HDMI_DDC_SCL, 65, "hdmi_ddc_scl", NULL, NULL,
			"gpio_65", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(HDMI_DDC_SDA, 66, "hdmi_ddc_sda", NULL, NULL,
			"gpio_66", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DX0, 0, "csi21_dx0", NULL, NULL, "gpi_67", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DY0, 0, "csi21_dy0", NULL, NULL, "gpi_68", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DX1, 0, "csi21_dx1", NULL, NULL, "gpi_69", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DY1, 0, "csi21_dy1", NULL, NULL, "gpi_70", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DX2, 0, "csi21_dx2", NULL, NULL, "gpi_71", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DY2, 0, "csi21_dy2", NULL, NULL, "gpi_72", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DX3, 0, "csi21_dx3", NULL, NULL, "gpi_73", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DY3, 0, "csi21_dy3", NULL, NULL, "gpi_74", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DX4, 0, "csi21_dx4", NULL, NULL, "gpi_75", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI21_DY4, 0, "csi21_dy4", NULL, NULL, "gpi_76", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI22_DX0, 0, "csi22_dx0", NULL, NULL, "gpi_77", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI22_DY0, 0, "csi22_dy0", NULL, NULL, "gpi_78", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI22_DX1, 0, "csi22_dx1", NULL, NULL, "gpi_79", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CSI22_DY1, 0, "csi22_dy1", NULL, NULL, "gpi_80", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CAM_SHUTTER, 81, "cam_shutter", NULL, NULL, "gpio_81",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CAM_STROBE, 82, "cam_strobe", NULL, NULL, "gpio_82",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(CAM_GLOBALRESET, 83, "cam_globalreset", NULL, NULL,
			"gpio_83", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_CLK, 84, "usbb1_ulpitll_clk",
			"hsi1_cawake", NULL, "gpio_84", "usbb1_ulpiphy_clk",
			NULL, "hw_dbg20", "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_STP, 85, "usbb1_ulpitll_stp",
			"hsi1_cadata", "mcbsp4_clkr", "gpio_85",
			"usbb1_ulpiphy_stp", "usbb1_mm_rxdp", "hw_dbg21",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DIR, 86, "usbb1_ulpitll_dir",
			"hsi1_caflag", "mcbsp4_fsr", "gpio_86",
			"usbb1_ulpiphy_dir", NULL, "hw_dbg22", "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_NXT, 87, "usbb1_ulpitll_nxt",
			"hsi1_acready", "mcbsp4_fsx", "gpio_87",
			"usbb1_ulpiphy_nxt", "usbb1_mm_rxdm", "hw_dbg23",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT0, 88, "usbb1_ulpitll_dat0",
			"hsi1_acwake", "mcbsp4_clkx", "gpio_88",
			"usbb1_ulpiphy_dat0", "usbb1_mm_txen", "hw_dbg24",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT1, 89, "usbb1_ulpitll_dat1",
			"hsi1_acdata", "mcbsp4_dx", "gpio_89",
			"usbb1_ulpiphy_dat1", "usbb1_mm_txdat", "hw_dbg25",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT2, 90, "usbb1_ulpitll_dat2",
			"hsi1_acflag", "mcbsp4_dr", "gpio_90",
			"usbb1_ulpiphy_dat2", "usbb1_mm_txse0", "hw_dbg26",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT3, 91, "usbb1_ulpitll_dat3",
			"hsi1_caready", NULL, "gpio_91", "usbb1_ulpiphy_dat3",
			"usbb1_mm_rxrcv", "hw_dbg27", "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT4, 92, "usbb1_ulpitll_dat4",
			"dmtimer8_pwm_evt", "abe_mcbsp3_dr", "gpio_92",
			"usbb1_ulpiphy_dat4", NULL, "hw_dbg28", "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT5, 93, "usbb1_ulpitll_dat5",
			"dmtimer9_pwm_evt", "abe_mcbsp3_dx", "gpio_93",
			"usbb1_ulpiphy_dat5", NULL, "hw_dbg29", "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT6, 94, "usbb1_ulpitll_dat6",
			"dmtimer10_pwm_evt", "abe_mcbsp3_clkx", "gpio_94",
			"usbb1_ulpiphy_dat6", "abe_dmic_din3", "hw_dbg30",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_ULPITLL_DAT7, 95, "usbb1_ulpitll_dat7",
			"dmtimer11_pwm_evt", "abe_mcbsp3_fsx", "gpio_95",
			"usbb1_ulpiphy_dat7", "abe_dmic_clk3", "hw_dbg31",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB1_HSIC_DATA, 96, "usbb1_hsic_data", NULL, NULL,
			"gpio_96", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBB1_HSIC_STROBE, 97, "usbb1_hsic_strobe", NULL,
			NULL, "gpio_97", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBC1_ICUSB_DP, 98, "usbc1_icusb_dp", NULL, NULL,
			"gpio_98", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBC1_ICUSB_DM, 99, "usbc1_icusb_dm", NULL, NULL,
			"gpio_99", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_CLK, 100, "sdmmc1_clk", NULL, "dpm_emu19",
			"gpio_100", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_CMD, 101, "sdmmc1_cmd", NULL, "uart1_rx",
			"gpio_101", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT0, 102, "sdmmc1_dat0", NULL, "dpm_emu18",
			"gpio_102", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT1, 103, "sdmmc1_dat1", NULL, "dpm_emu17",
			"gpio_103", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT2, 104, "sdmmc1_dat2", NULL, "dpm_emu16",
			"gpio_104", "jtag_tms_tmsc", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT3, 105, "sdmmc1_dat3", NULL, "dpm_emu15",
			"gpio_105", "jtag_tck", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT4, 106, "sdmmc1_dat4", NULL, NULL,
			"gpio_106", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT5, 107, "sdmmc1_dat5", NULL, NULL,
			"gpio_107", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT6, 108, "sdmmc1_dat6", NULL, NULL,
			"gpio_108", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC1_DAT7, 109, "sdmmc1_dat7", NULL, NULL,
			"gpio_109", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP2_CLKX, 110, "abe_mcbsp2_clkx", "mcspi2_clk",
			"abe_mcasp_ahclkx", "gpio_110", "usbb2_mm_rxdm",
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP2_DR, 111, "abe_mcbsp2_dr", "mcspi2_somi",
			"abe_mcasp_axr", "gpio_111", "usbb2_mm_rxdp", NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP2_DX, 112, "abe_mcbsp2_dx", "mcspi2_simo",
			"abe_mcasp_amute", "gpio_112", "usbb2_mm_rxrcv", NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP2_FSX, 113, "abe_mcbsp2_fsx", "mcspi2_cs0",
			"abe_mcasp_afsx", "gpio_113", "usbb2_mm_txen", NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP1_CLKX, 114, "abe_mcbsp1_clkx",
			"abe_slimbus1_clock", NULL, "gpio_114", NULL, NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP1_DR, 115, "abe_mcbsp1_dr",
			"abe_slimbus1_data", NULL, "gpio_115", NULL, NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP1_DX, 116, "abe_mcbsp1_dx", "sdmmc3_dat2",
			"abe_mcasp_aclkx", "gpio_116", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(ABE_MCBSP1_FSX, 117, "abe_mcbsp1_fsx", "sdmmc3_dat3",
			"abe_mcasp_amutein", "gpio_117", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(ABE_PDM_UL_DATA, 0, "abe_pdm_ul_data",
			"abe_mcbsp3_dr", NULL, NULL, NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(ABE_PDM_DL_DATA, 0, "abe_pdm_dl_data",
			"abe_mcbsp3_dx", NULL, NULL, NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(ABE_PDM_FRAME, 0, "abe_pdm_frame", "abe_mcbsp3_clkx",
			NULL, NULL, NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_PDM_LB_CLK, 0, "abe_pdm_lb_clk", "abe_mcbsp3_fsx",
			NULL, NULL, NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_CLKS, 118, "abe_clks", NULL, NULL, "gpio_118",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_DMIC_CLK1, 119, "abe_dmic_clk1", NULL, NULL,
			"gpio_119", "usbb2_mm_txse0", "uart4_cts", NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(ABE_DMIC_DIN1, 120, "abe_dmic_din1", NULL, NULL,
			"gpio_120", "usbb2_mm_txdat", "uart4_rts", NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(ABE_DMIC_DIN2, 121, "abe_dmic_din2", "slimbus2_clock",
			"abe_mcasp_axr", "gpio_121", NULL,
			"dmtimer11_pwm_evt", NULL, "safe_mode"),
	_OMAP4_MUXENTRY(ABE_DMIC_DIN3, 122, "abe_dmic_din3", "slimbus2_data",
			"abe_dmic_clk2", "gpio_122", NULL, "dmtimer9_pwm_evt",
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART2_CTS, 123, "uart2_cts", "sdmmc3_clk", NULL,
			"gpio_123", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART2_RTS, 124, "uart2_rts", "sdmmc3_cmd", NULL,
			"gpio_124", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART2_RX, 125, "uart2_rx", "sdmmc3_dat0", NULL,
			"gpio_125", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART2_TX, 126, "uart2_tx", "sdmmc3_dat1", NULL,
			"gpio_126", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(HDQ_SIO, 127, "hdq_sio", "i2c3_sccb", "i2c2_sccb",
			"gpio_127", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(I2C1_SCL, 0, "i2c1_scl", NULL, NULL, NULL, NULL, NULL,
			NULL, NULL),
	_OMAP4_MUXENTRY(I2C1_SDA, 0, "i2c1_sda", NULL, NULL, NULL, NULL, NULL,
			NULL, NULL),
	_OMAP4_MUXENTRY(I2C2_SCL, 128, "i2c2_scl", "uart1_rx", NULL,
			"gpio_128", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(I2C2_SDA, 129, "i2c2_sda", "uart1_tx", NULL,
			"gpio_129", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(I2C3_SCL, 130, "i2c3_scl", NULL, NULL, "gpio_130",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(I2C3_SDA, 131, "i2c3_sda", NULL, NULL, "gpio_131",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(I2C4_SCL, 132, "i2c4_scl", NULL, NULL, "gpio_132",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(I2C4_SDA, 133, "i2c4_sda", NULL, NULL, "gpio_133",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_CLK, 134, "mcspi1_clk", NULL, NULL, "gpio_134",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_SOMI, 135, "mcspi1_somi", NULL, NULL,
			"gpio_135", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_SIMO, 136, "mcspi1_simo", NULL, NULL,
			"gpio_136", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_CS0, 137, "mcspi1_cs0", NULL, NULL, "gpio_137",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_CS1, 138, "mcspi1_cs1", "uart1_rx", NULL,
			"gpio_138", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_CS2, 139, "mcspi1_cs2", "uart1_cts",
			"slimbus2_clock", "gpio_139", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(MCSPI1_CS3, 140, "mcspi1_cs3", "uart1_rts",
			"slimbus2_data", "gpio_140", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(UART3_CTS_RCTX, 141, "uart3_cts_rctx", "uart1_tx",
			NULL, "gpio_141", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART3_RTS_SD, 142, "uart3_rts_sd", NULL, NULL,
			"gpio_142", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART3_RX_IRRX, 143, "uart3_rx_irrx",
			"dmtimer8_pwm_evt", NULL, "gpio_143", NULL, NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART3_TX_IRTX, 144, "uart3_tx_irtx",
			"dmtimer9_pwm_evt", NULL, "gpio_144", NULL, NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC5_CLK, 145, "sdmmc5_clk", "mcspi2_clk",
			"usbc1_icusb_dp", "gpio_145", NULL, "sdmmc2_clk",
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC5_CMD, 146, "sdmmc5_cmd", "mcspi2_simo",
			"usbc1_icusb_dm", "gpio_146", NULL, "sdmmc2_cmd",
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC5_DAT0, 147, "sdmmc5_dat0", "mcspi2_somi",
			"usbc1_icusb_rcv", "gpio_147", NULL, "sdmmc2_dat0",
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC5_DAT1, 148, "sdmmc5_dat1", NULL,
			"usbc1_icusb_txen", "gpio_148", NULL, "sdmmc2_dat1",
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC5_DAT2, 149, "sdmmc5_dat2", "mcspi2_cs1", NULL,
			"gpio_149", NULL, "sdmmc2_dat2", NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SDMMC5_DAT3, 150, "sdmmc5_dat3", "mcspi2_cs0", NULL,
			"gpio_150", NULL, "sdmmc2_dat3", NULL, "safe_mode"),
	_OMAP4_MUXENTRY(MCSPI4_CLK, 151, "mcspi4_clk", "sdmmc4_clk",
			"kpd_col6", "gpio_151", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(MCSPI4_SIMO, 152, "mcspi4_simo", "sdmmc4_cmd",
			"kpd_col7", "gpio_152", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(MCSPI4_SOMI, 153, "mcspi4_somi", "sdmmc4_dat0",
			"kpd_row6", "gpio_153", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(MCSPI4_CS0, 154, "mcspi4_cs0", "sdmmc4_dat3",
			"kpd_row7", "gpio_154", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(UART4_RX, 155, "uart4_rx", "sdmmc4_dat2", "kpd_row8",
			"gpio_155", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(UART4_TX, 156, "uart4_tx", "sdmmc4_dat1", "kpd_col8",
			"gpio_156", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_CLK, 157, "usbb2_ulpitll_clk",
			"usbb2_ulpiphy_clk", "sdmmc4_cmd", "gpio_157",
			"hsi2_cawake", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_STP, 158, "usbb2_ulpitll_stp",
			"usbb2_ulpiphy_stp", "sdmmc4_clk", "gpio_158",
			"hsi2_cadata", "dispc2_data23", NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DIR, 159, "usbb2_ulpitll_dir",
			"usbb2_ulpiphy_dir", "sdmmc4_dat0", "gpio_159",
			"hsi2_caflag", "dispc2_data22", NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_NXT, 160, "usbb2_ulpitll_nxt",
			"usbb2_ulpiphy_nxt", "sdmmc4_dat1", "gpio_160",
			"hsi2_acready", "dispc2_data21", NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT0, 161, "usbb2_ulpitll_dat0",
			"usbb2_ulpiphy_dat0", "sdmmc4_dat2", "gpio_161",
			"hsi2_acwake", "dispc2_data20", "usbb2_mm_txen",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT1, 162, "usbb2_ulpitll_dat1",
			"usbb2_ulpiphy_dat1", "sdmmc4_dat3", "gpio_162",
			"hsi2_acdata", "dispc2_data19", "usbb2_mm_txdat",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT2, 163, "usbb2_ulpitll_dat2",
			"usbb2_ulpiphy_dat2", "sdmmc3_dat2", "gpio_163",
			"hsi2_acflag", "dispc2_data18", "usbb2_mm_txse0",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT3, 164, "usbb2_ulpitll_dat3",
			"usbb2_ulpiphy_dat3", "sdmmc3_dat1", "gpio_164",
			"hsi2_caready", "dispc2_data15", "rfbi_data15",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT4, 165, "usbb2_ulpitll_dat4",
			"usbb2_ulpiphy_dat4", "sdmmc3_dat0", "gpio_165",
			"mcspi3_somi", "dispc2_data14", "rfbi_data14",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT5, 166, "usbb2_ulpitll_dat5",
			"usbb2_ulpiphy_dat5", "sdmmc3_dat3", "gpio_166",
			"mcspi3_cs0", "dispc2_data13", "rfbi_data13",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT6, 167, "usbb2_ulpitll_dat6",
			"usbb2_ulpiphy_dat6", "sdmmc3_cmd", "gpio_167",
			"mcspi3_simo", "dispc2_data12", "rfbi_data12",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB2_ULPITLL_DAT7, 168, "usbb2_ulpitll_dat7",
			"usbb2_ulpiphy_dat7", "sdmmc3_clk", "gpio_168",
			"mcspi3_clk", "dispc2_data11", "rfbi_data11",
			"safe_mode"),
	_OMAP4_MUXENTRY(USBB2_HSIC_DATA, 169, "usbb2_hsic_data", NULL, NULL,
			"gpio_169", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBB2_HSIC_STROBE, 170, "usbb2_hsic_strobe", NULL,
			NULL, "gpio_170", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(KPD_COL3, 171, "kpd_col3", "kpd_col0", NULL,
			"gpio_171", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(KPD_COL4, 172, "kpd_col4", "kpd_col1", NULL,
			"gpio_172", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(KPD_COL5, 173, "kpd_col5", "kpd_col2", NULL,
			"gpio_173", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(KPD_COL0, 174, "kpd_col0", "kpd_col3", NULL,
			"gpio_174", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(KPD_COL1, 0, "kpd_col1", "kpd_col4", NULL, "gpio_0",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(KPD_COL2, 1, "kpd_col2", "kpd_col5", NULL, "gpio_1",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(KPD_ROW3, 175, "kpd_row3", "kpd_row0", NULL,
			"gpio_175", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(KPD_ROW4, 176, "kpd_row4", "kpd_row1", NULL,
			"gpio_176", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(KPD_ROW5, 177, "kpd_row5", "kpd_row2", NULL,
			"gpio_177", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(KPD_ROW0, 178, "kpd_row0", "kpd_row3", NULL,
			"gpio_178", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(KPD_ROW1, 2, "kpd_row1", "kpd_row4", NULL, "gpio_2",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(KPD_ROW2, 3, "kpd_row2", "kpd_row5", NULL, "gpio_3",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBA0_OTG_CE, 0, "usba0_otg_ce", NULL, NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(USBA0_OTG_DP, 0, "usba0_otg_dp", "uart3_rx_irrx",
			"uart2_rx", NULL, NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(USBA0_OTG_DM, 0, "usba0_otg_dm", "uart3_tx_irtx",
			"uart2_tx", NULL, NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(FREF_CLK1_OUT, 181, "fref_clk1_out", NULL, NULL,
			"gpio_181", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(FREF_CLK2_OUT, 182, "fref_clk2_out", NULL, NULL,
			"gpio_182", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_NIRQ1, 0, "sys_nirq1", NULL, NULL, NULL, NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_NIRQ2, 183, "sys_nirq2", NULL, NULL, "gpio_183",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_BOOT0, 184, "sys_boot0", NULL, NULL, "gpio_184",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_BOOT1, 185, "sys_boot1", NULL, NULL, "gpio_185",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_BOOT2, 186, "sys_boot2", NULL, NULL, "gpio_186",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_BOOT3, 187, "sys_boot3", NULL, NULL, "gpio_187",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_BOOT4, 188, "sys_boot4", NULL, NULL, "gpio_188",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SYS_BOOT5, 189, "sys_boot5", NULL, NULL, "gpio_189",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU0, 11, "dpm_emu0", NULL, NULL, "gpio_11", NULL,
			NULL, "hw_dbg0", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU1, 12, "dpm_emu1", NULL, NULL, "gpio_12", NULL,
			NULL, "hw_dbg1", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU2, 13, "dpm_emu2", "usba0_ulpiphy_clk", NULL,
			"gpio_13", NULL, "dispc2_fid", "hw_dbg2",
			"safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU3, 14, "dpm_emu3", "usba0_ulpiphy_stp", NULL,
			"gpio_14", "rfbi_data10", "dispc2_data10", "hw_dbg3",
			"safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU4, 15, "dpm_emu4", "usba0_ulpiphy_dir", NULL,
			"gpio_15", "rfbi_data9", "dispc2_data9", "hw_dbg4",
			"safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU5, 16, "dpm_emu5", "usba0_ulpiphy_nxt", NULL,
			"gpio_16", "rfbi_te_vsync0", "dispc2_data16",
			"hw_dbg5", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU6, 17, "dpm_emu6", "usba0_ulpiphy_dat0",
			"uart3_tx_irtx", "gpio_17", "rfbi_hsync0",
			"dispc2_data17", "hw_dbg6", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU7, 18, "dpm_emu7", "usba0_ulpiphy_dat1",
			"uart3_rx_irrx", "gpio_18", "rfbi_cs0",
			"dispc2_hsync", "hw_dbg7", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU8, 19, "dpm_emu8", "usba0_ulpiphy_dat2",
			"uart3_rts_sd", "gpio_19", "rfbi_re", "dispc2_pclk",
			"hw_dbg8", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU9, 20, "dpm_emu9", "usba0_ulpiphy_dat3",
			"uart3_cts_rctx", "gpio_20", "rfbi_we",
			"dispc2_vsync", "hw_dbg9", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU10, 21, "dpm_emu10", "usba0_ulpiphy_dat4",
			NULL, "gpio_21", "rfbi_a0", "dispc2_de", "hw_dbg10",
			"safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU11, 22, "dpm_emu11", "usba0_ulpiphy_dat5",
			NULL, "gpio_22", "rfbi_data8", "dispc2_data8",
			"hw_dbg11", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU12, 23, "dpm_emu12", "usba0_ulpiphy_dat6",
			NULL, "gpio_23", "rfbi_data7", "dispc2_data7",
			"hw_dbg12", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU13, 24, "dpm_emu13", "usba0_ulpiphy_dat7",
			NULL, "gpio_24", "rfbi_data6", "dispc2_data6",
			"hw_dbg13", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU14, 25, "dpm_emu14", "sys_drm_msecure",
			"uart1_rx", "gpio_25", "rfbi_data5", "dispc2_data5",
			"hw_dbg14", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU15, 26, "dpm_emu15", "sys_secure_indicator",
			NULL, "gpio_26", "rfbi_data4", "dispc2_data4",
			"hw_dbg15", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU16, 27, "dpm_emu16", "dmtimer8_pwm_evt",
			"dsi1_te0", "gpio_27", "rfbi_data3", "dispc2_data3",
			"hw_dbg16", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU17, 28, "dpm_emu17", "dmtimer9_pwm_evt",
			"dsi1_te1", "gpio_28", "rfbi_data2", "dispc2_data2",
			"hw_dbg17", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU18, 190, "dpm_emu18", "dmtimer10_pwm_evt",
			"dsi2_te0", "gpio_190", "rfbi_data1", "dispc2_data1",
			"hw_dbg18", "safe_mode"),
	_OMAP4_MUXENTRY(DPM_EMU19, 191, "dpm_emu19", "dmtimer11_pwm_evt",
			"dsi2_te1", "gpio_191", "rfbi_data0", "dispc2_data0",
			"hw_dbg19", "safe_mode"),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};

/*
 * Balls for 44XX CBS package
 * 547-pin CBL ES2.0 S-FPGA-N547, 0.40mm Ball Pitch (Top),
 *				  0.40mm Ball Pitch (Bottom)
 */
#if defined(CONFIG_OMAP_MUX) && defined(CONFIG_DEBUG_FS)		\
		&& defined(CONFIG_OMAP_PACKAGE_CBS)
struct omap_ball __initdata omap4_core_cbs_ball[] = {
	_OMAP4_BALLENTRY(GPMC_AD0, "c12", NULL),
	_OMAP4_BALLENTRY(GPMC_AD1, "d12", NULL),
	_OMAP4_BALLENTRY(GPMC_AD2, "c13", NULL),
	_OMAP4_BALLENTRY(GPMC_AD3, "d13", NULL),
	_OMAP4_BALLENTRY(GPMC_AD4, "c15", NULL),
	_OMAP4_BALLENTRY(GPMC_AD5, "d15", NULL),
	_OMAP4_BALLENTRY(GPMC_AD6, "a16", NULL),
	_OMAP4_BALLENTRY(GPMC_AD7, "b16", NULL),
	_OMAP4_BALLENTRY(GPMC_AD8, "c16", NULL),
	_OMAP4_BALLENTRY(GPMC_AD9, "d16", NULL),
	_OMAP4_BALLENTRY(GPMC_AD10, "c17", NULL),
	_OMAP4_BALLENTRY(GPMC_AD11, "d17", NULL),
	_OMAP4_BALLENTRY(GPMC_AD12, "c18", NULL),
	_OMAP4_BALLENTRY(GPMC_AD13, "d18", NULL),
	_OMAP4_BALLENTRY(GPMC_AD14, "c19", NULL),
	_OMAP4_BALLENTRY(GPMC_AD15, "d19", NULL),
	_OMAP4_BALLENTRY(GPMC_A16, "b17", NULL),
	_OMAP4_BALLENTRY(GPMC_A17, "a18", NULL),
	_OMAP4_BALLENTRY(GPMC_A18, "b18", NULL),
	_OMAP4_BALLENTRY(GPMC_A19, "a19", NULL),
	_OMAP4_BALLENTRY(GPMC_A20, "b19", NULL),
	_OMAP4_BALLENTRY(GPMC_A21, "b20", NULL),
	_OMAP4_BALLENTRY(GPMC_A22, "a21", NULL),
	_OMAP4_BALLENTRY(GPMC_A23, "b21", NULL),
	_OMAP4_BALLENTRY(GPMC_A24, "c20", NULL),
	_OMAP4_BALLENTRY(GPMC_A25, "d20", NULL),
	_OMAP4_BALLENTRY(GPMC_NCS0, "b25", NULL),
	_OMAP4_BALLENTRY(GPMC_NCS1, "c21", NULL),
	_OMAP4_BALLENTRY(GPMC_NCS2, "d21", NULL),
	_OMAP4_BALLENTRY(GPMC_NCS3, "c22", NULL),
	_OMAP4_BALLENTRY(GPMC_NWP, "c25", NULL),
	_OMAP4_BALLENTRY(GPMC_CLK, "b22", NULL),
	_OMAP4_BALLENTRY(GPMC_NADV_ALE, "d25", NULL),
	_OMAP4_BALLENTRY(GPMC_NOE, "b11", NULL),
	_OMAP4_BALLENTRY(GPMC_NWE, "b12", NULL),
	_OMAP4_BALLENTRY(GPMC_NBE0_CLE, "c23", NULL),
	_OMAP4_BALLENTRY(GPMC_NBE1, "d22", NULL),
	_OMAP4_BALLENTRY(GPMC_WAIT0, "b26", NULL),
	_OMAP4_BALLENTRY(GPMC_WAIT1, "b23", NULL),
	_OMAP4_BALLENTRY(GPMC_WAIT2, "d23", NULL),
	_OMAP4_BALLENTRY(GPMC_NCS4, "a24", NULL),
	_OMAP4_BALLENTRY(GPMC_NCS5, "b24", NULL),
	_OMAP4_BALLENTRY(GPMC_NCS6, "c24", NULL),
	_OMAP4_BALLENTRY(GPMC_NCS7, "d24", NULL),
	_OMAP4_BALLENTRY(HDMI_HPD, "b9", NULL),
	_OMAP4_BALLENTRY(HDMI_CEC, "b10", NULL),
	_OMAP4_BALLENTRY(HDMI_DDC_SCL, "a8", NULL),
	_OMAP4_BALLENTRY(HDMI_DDC_SDA, "b8", NULL),
	_OMAP4_BALLENTRY(CSI21_DX0, "r26", NULL),
	_OMAP4_BALLENTRY(CSI21_DY0, "r25", NULL),
	_OMAP4_BALLENTRY(CSI21_DX1, "t26", NULL),
	_OMAP4_BALLENTRY(CSI21_DY1, "t25", NULL),
	_OMAP4_BALLENTRY(CSI21_DX2, "u26", NULL),
	_OMAP4_BALLENTRY(CSI21_DY2, "u25", NULL),
	_OMAP4_BALLENTRY(CSI21_DX3, "v26", NULL),
	_OMAP4_BALLENTRY(CSI21_DY3, "v25", NULL),
	_OMAP4_BALLENTRY(CSI21_DX4, "w26", NULL),
	_OMAP4_BALLENTRY(CSI21_DY4, "w25", NULL),
	_OMAP4_BALLENTRY(CSI22_DX0, "m26", NULL),
	_OMAP4_BALLENTRY(CSI22_DY0, "m25", NULL),
	_OMAP4_BALLENTRY(CSI22_DX1, "n26", NULL),
	_OMAP4_BALLENTRY(CSI22_DY1, "n25", NULL),
	_OMAP4_BALLENTRY(CAM_SHUTTER, "t27", NULL),
	_OMAP4_BALLENTRY(CAM_STROBE, "u27", NULL),
	_OMAP4_BALLENTRY(CAM_GLOBALRESET, "v27", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_CLK, "ae18", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_STP, "ag19", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DIR, "af19", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_NXT, "ae19", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT0, "af18", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT1, "ag18", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT2, "ae17", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT3, "af17", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT4, "ah17", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT5, "ae16", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT6, "af16", NULL),
	_OMAP4_BALLENTRY(USBB1_ULPITLL_DAT7, "ag16", NULL),
	_OMAP4_BALLENTRY(USBB1_HSIC_DATA, "af14", NULL),
	_OMAP4_BALLENTRY(USBB1_HSIC_STROBE, "ae14", NULL),
	_OMAP4_BALLENTRY(USBC1_ICUSB_DP, "h2", NULL),
	_OMAP4_BALLENTRY(USBC1_ICUSB_DM, "h3", NULL),
	_OMAP4_BALLENTRY(SDMMC1_CLK, "d2", NULL),
	_OMAP4_BALLENTRY(SDMMC1_CMD, "e3", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT0, "e4", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT1, "e2", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT2, "e1", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT3, "f4", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT4, "f3", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT5, "f1", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT6, "g4", NULL),
	_OMAP4_BALLENTRY(SDMMC1_DAT7, "g3", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP2_CLKX, "ad27", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP2_DR, "ad26", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP2_DX, "ad25", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP2_FSX, "ac28", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP1_CLKX, "ac26", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP1_DR, "ac25", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP1_DX, "ab25", NULL),
	_OMAP4_BALLENTRY(ABE_MCBSP1_FSX, "ac27", NULL),
	_OMAP4_BALLENTRY(ABE_PDM_UL_DATA, "ag25", NULL),
	_OMAP4_BALLENTRY(ABE_PDM_DL_DATA, "af25", NULL),
	_OMAP4_BALLENTRY(ABE_PDM_FRAME, "ae25", NULL),
	_OMAP4_BALLENTRY(ABE_PDM_LB_CLK, "af26", NULL),
	_OMAP4_BALLENTRY(ABE_CLKS, "ah26", NULL),
	_OMAP4_BALLENTRY(ABE_DMIC_CLK1, "ae24", NULL),
	_OMAP4_BALLENTRY(ABE_DMIC_DIN1, "af24", NULL),
	_OMAP4_BALLENTRY(ABE_DMIC_DIN2, "ag24", NULL),
	_OMAP4_BALLENTRY(ABE_DMIC_DIN3, "ah24", NULL),
	_OMAP4_BALLENTRY(UART2_CTS, "ab26", NULL),
	_OMAP4_BALLENTRY(UART2_RTS, "ab27", NULL),
	_OMAP4_BALLENTRY(UART2_RX, "aa25", NULL),
	_OMAP4_BALLENTRY(UART2_TX, "aa26", NULL),
	_OMAP4_BALLENTRY(HDQ_SIO, "aa27", NULL),
	_OMAP4_BALLENTRY(I2C1_SCL, "ae28", NULL),
	_OMAP4_BALLENTRY(I2C1_SDA, "ae26", NULL),
	_OMAP4_BALLENTRY(I2C2_SCL, "c26", NULL),
	_OMAP4_BALLENTRY(I2C2_SDA, "d26", NULL),
	_OMAP4_BALLENTRY(I2C3_SCL, "w27", NULL),
	_OMAP4_BALLENTRY(I2C3_SDA, "y27", NULL),
	_OMAP4_BALLENTRY(I2C4_SCL, "ag21", NULL),
	_OMAP4_BALLENTRY(I2C4_SDA, "ah22", NULL),
	_OMAP4_BALLENTRY(MCSPI1_CLK, "af22", NULL),
	_OMAP4_BALLENTRY(MCSPI1_SOMI, "ae22", NULL),
	_OMAP4_BALLENTRY(MCSPI1_SIMO, "ag22", NULL),
	_OMAP4_BALLENTRY(MCSPI1_CS0, "ae23", NULL),
	_OMAP4_BALLENTRY(MCSPI1_CS1, "af23", NULL),
	_OMAP4_BALLENTRY(MCSPI1_CS2, "ag23", NULL),
	_OMAP4_BALLENTRY(MCSPI1_CS3, "ah23", NULL),
	_OMAP4_BALLENTRY(UART3_CTS_RCTX, "f27", NULL),
	_OMAP4_BALLENTRY(UART3_RTS_SD, "f28", NULL),
	_OMAP4_BALLENTRY(UART3_RX_IRRX, "g27", NULL),
	_OMAP4_BALLENTRY(UART3_TX_IRTX, "g28", NULL),
	_OMAP4_BALLENTRY(SDMMC5_CLK, "ae5", NULL),
	_OMAP4_BALLENTRY(SDMMC5_CMD, "af5", NULL),
	_OMAP4_BALLENTRY(SDMMC5_DAT0, "ae4", NULL),
	_OMAP4_BALLENTRY(SDMMC5_DAT1, "af4", NULL),
	_OMAP4_BALLENTRY(SDMMC5_DAT2, "ag3", NULL),
	_OMAP4_BALLENTRY(SDMMC5_DAT3, "af3", NULL),
	_OMAP4_BALLENTRY(MCSPI4_CLK, "ae21", NULL),
	_OMAP4_BALLENTRY(MCSPI4_SIMO, "af20", NULL),
	_OMAP4_BALLENTRY(MCSPI4_SOMI, "af21", NULL),
	_OMAP4_BALLENTRY(MCSPI4_CS0, "ae20", NULL),
	_OMAP4_BALLENTRY(UART4_RX, "ag20", NULL),
	_OMAP4_BALLENTRY(UART4_TX, "ah19", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_CLK, "ag12", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_STP, "af12", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DIR, "ae12", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_NXT, "ag13", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT0, "ae11", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT1, "af11", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT2, "ag11", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT3, "ah11", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT4, "ae10", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT5, "af10", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT6, "ag10", NULL),
	_OMAP4_BALLENTRY(USBB2_ULPITLL_DAT7, "ae9", NULL),
	_OMAP4_BALLENTRY(USBB2_HSIC_DATA, "af13", NULL),
	_OMAP4_BALLENTRY(USBB2_HSIC_STROBE, "ae13", NULL),
	_OMAP4_BALLENTRY(KPD_COL3, "g26", NULL),
	_OMAP4_BALLENTRY(KPD_COL4, "g25", NULL),
	_OMAP4_BALLENTRY(KPD_COL5, "h26", NULL),
	_OMAP4_BALLENTRY(KPD_COL0, "h25", NULL),
	_OMAP4_BALLENTRY(KPD_COL1, "j27", NULL),
	_OMAP4_BALLENTRY(KPD_COL2, "h27", NULL),
	_OMAP4_BALLENTRY(KPD_ROW3, "j26", NULL),
	_OMAP4_BALLENTRY(KPD_ROW4, "j25", NULL),
	_OMAP4_BALLENTRY(KPD_ROW5, "k26", NULL),
	_OMAP4_BALLENTRY(KPD_ROW0, "k25", NULL),
	_OMAP4_BALLENTRY(KPD_ROW1, "l27", NULL),
	_OMAP4_BALLENTRY(KPD_ROW2, "k27", NULL),
	_OMAP4_BALLENTRY(USBA0_OTG_CE, "c3", NULL),
	_OMAP4_BALLENTRY(USBA0_OTG_DP, "b5", NULL),
	_OMAP4_BALLENTRY(USBA0_OTG_DM, "b4", NULL),
	_OMAP4_BALLENTRY(FREF_CLK1_OUT, "aa28", NULL),
	_OMAP4_BALLENTRY(FREF_CLK2_OUT, "y28", NULL),
	_OMAP4_BALLENTRY(SYS_NIRQ1, "ae6", NULL),
	_OMAP4_BALLENTRY(SYS_NIRQ2, "af6", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT0, "f26", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT1, "e27", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT2, "e26", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT3, "e25", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT4, "d28", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT5, "d27", NULL),
	_OMAP4_BALLENTRY(DPM_EMU0, "m2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU1, "n2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU2, "p2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU3, "v1", NULL),
	_OMAP4_BALLENTRY(DPM_EMU4, "v2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU5, "w1", NULL),
	_OMAP4_BALLENTRY(DPM_EMU6, "w2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU7, "w3", NULL),
	_OMAP4_BALLENTRY(DPM_EMU8, "w4", NULL),
	_OMAP4_BALLENTRY(DPM_EMU9, "y2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU10, "y3", NULL),
	_OMAP4_BALLENTRY(DPM_EMU11, "y4", NULL),
	_OMAP4_BALLENTRY(DPM_EMU12, "aa1", NULL),
	_OMAP4_BALLENTRY(DPM_EMU13, "aa2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU14, "aa3", NULL),
	_OMAP4_BALLENTRY(DPM_EMU15, "aa4", NULL),
	_OMAP4_BALLENTRY(DPM_EMU16, "ab2", NULL),
	_OMAP4_BALLENTRY(DPM_EMU17, "ab3", NULL),
	_OMAP4_BALLENTRY(DPM_EMU18, "ab4", NULL),
	_OMAP4_BALLENTRY(DPM_EMU19, "ac4", NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#else
#define omap4_core_cbs_ball  NULL
#endif

/*
 * Superset of all mux modes for omap4
 */
static struct omap_mux __initdata omap4_wkup_muxmodes[] = {
	_OMAP4_MUXENTRY(SIM_IO, 0, "sim_io", NULL, NULL, "gpio_wk0", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SIM_CLK, 1, "sim_clk", NULL, NULL, "gpio_wk1", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SIM_RESET, 2, "sim_reset", NULL, NULL, "gpio_wk2",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SIM_CD, 3, "sim_cd", NULL, NULL, "gpio_wk3", NULL,
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SIM_PWRCTRL, 4, "sim_pwrctrl", NULL, NULL, "gpio_wk4",
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(SR_SCL, 0, "sr_scl", NULL, NULL, NULL, NULL, NULL,
			NULL, NULL),
	_OMAP4_MUXENTRY(SR_SDA, 0, "sr_sda", NULL, NULL, NULL, NULL, NULL,
			NULL, NULL),
	_OMAP4_MUXENTRY(FREF_XTAL_IN, 0, "fref_xtal_in", NULL, NULL, NULL,
			"c2c_wakereqin", NULL, NULL, NULL),
	_OMAP4_MUXENTRY(FREF_SLICER_IN, 0, "fref_slicer_in", NULL, NULL,
			"gpi_wk5", "c2c_wakereqin", NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(FREF_CLK_IOREQ, 0, "fref_clk_ioreq", NULL, NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(FREF_CLK0_OUT, 6, "fref_clk0_out", "fref_clk1_req",
			"sys_drm_msecure", "gpio_wk6", NULL, NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(FREF_CLK3_REQ, 30, "fref_clk3_req", "fref_clk1_req",
			"sys_drm_msecure", "gpio_wk30", "c2c_wakereqin", NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(FREF_CLK3_OUT, 31, "fref_clk3_out", "fref_clk2_req",
			"sys_secure_indicator", "gpio_wk31", "c2c_wakereqout",
			NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(FREF_CLK4_REQ, 7, "fref_clk4_req", "fref_clk5_out",
			NULL, "gpio_wk7", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(FREF_CLK4_OUT, 8, "fref_clk4_out", NULL, NULL,
			"gpio_wk8", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(SYS_32K, 0, "sys_32k", NULL, NULL, NULL, NULL, NULL,
			NULL, NULL),
	_OMAP4_MUXENTRY(SYS_NRESPWRON, 0, "sys_nrespwron", NULL, NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(SYS_NRESWARM, 0, "sys_nreswarm", NULL, NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(SYS_PWR_REQ, 0, "sys_pwr_req", NULL, NULL, NULL, NULL,
			NULL, NULL, NULL),
	_OMAP4_MUXENTRY(SYS_PWRON_RESET_OUT, 29, "sys_pwron_reset_out", NULL,
			NULL, "gpio_wk29", NULL, NULL, NULL, NULL),
	_OMAP4_MUXENTRY(SYS_BOOT6, 9, "sys_boot6", "dpm_emu18", NULL,
			"gpio_wk9", "c2c_wakereqout", NULL, NULL,
			"safe_mode"),
	_OMAP4_MUXENTRY(SYS_BOOT7, 10, "sys_boot7", "dpm_emu19", NULL,
			"gpio_wk10", NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(JTAG_NTRST, 0, "jtag_ntrst", NULL, NULL, NULL, NULL,
			NULL, NULL, NULL),
	_OMAP4_MUXENTRY(JTAG_TCK, 0, "jtag_tck", NULL, NULL, NULL, NULL, NULL,
			NULL, "safe_mode"),
	_OMAP4_MUXENTRY(JTAG_RTCK, 0, "jtag_rtck", NULL, NULL, NULL, NULL,
			NULL, NULL, NULL),
	_OMAP4_MUXENTRY(JTAG_TMS_TMSC, 0, "jtag_tms_tmsc", NULL, NULL, NULL,
			NULL, NULL, NULL, "safe_mode"),
	_OMAP4_MUXENTRY(JTAG_TDI, 0, "jtag_tdi", NULL, NULL, NULL, NULL, NULL,
			NULL, NULL),
	_OMAP4_MUXENTRY(JTAG_TDO, 0, "jtag_tdo", NULL, NULL, NULL, NULL, NULL,
			NULL, NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};

/*
 * Balls for 44XX CBL & CBS package - wakeup partition
 * 547-pin CBL ES1.0 S-FPGA-N547, 0.40mm Ball Pitch (Top),
 *				  0.40mm Ball Pitch (Bottom)
 */
#if defined(CONFIG_OMAP_MUX) && defined(CONFIG_DEBUG_FS)		\
		&& defined(CONFIG_OMAP_PACKAGE_CBL)
struct omap_ball __initdata omap4_wkup_cbl_cbs_ball[] = {
	_OMAP4_BALLENTRY(SIM_IO, "h4", NULL),
	_OMAP4_BALLENTRY(SIM_CLK, "j2", NULL),
	_OMAP4_BALLENTRY(SIM_RESET, "g2", NULL),
	_OMAP4_BALLENTRY(SIM_CD, "j1", NULL),
	_OMAP4_BALLENTRY(SIM_PWRCTRL, "k1", NULL),
	_OMAP4_BALLENTRY(SR_SCL, "ag9", NULL),
	_OMAP4_BALLENTRY(SR_SDA, "af9", NULL),
	_OMAP4_BALLENTRY(FREF_XTAL_IN, "ah6", NULL),
	_OMAP4_BALLENTRY(FREF_SLICER_IN, "ag8", NULL),
	_OMAP4_BALLENTRY(FREF_CLK_IOREQ, "ad1", NULL),
	_OMAP4_BALLENTRY(FREF_CLK0_OUT, "ad2", NULL),
	_OMAP4_BALLENTRY(FREF_CLK3_REQ, "ad3", NULL),
	_OMAP4_BALLENTRY(FREF_CLK3_OUT, "ad4", NULL),
	_OMAP4_BALLENTRY(FREF_CLK4_REQ, "ac2", NULL),
	_OMAP4_BALLENTRY(FREF_CLK4_OUT, "ac3", NULL),
	_OMAP4_BALLENTRY(SYS_32K, "ag7", NULL),
	_OMAP4_BALLENTRY(SYS_NRESPWRON, "ae7", NULL),
	_OMAP4_BALLENTRY(SYS_NRESWARM, "af7", NULL),
	_OMAP4_BALLENTRY(SYS_PWR_REQ, "ah7", NULL),
	_OMAP4_BALLENTRY(SYS_PWRON_RESET_OUT, "ag6", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT6, "af8", NULL),
	_OMAP4_BALLENTRY(SYS_BOOT7, "ae8", NULL),
	_OMAP4_BALLENTRY(JTAG_NTRST, "ah2", NULL),
	_OMAP4_BALLENTRY(JTAG_TCK, "ag1", NULL),
	_OMAP4_BALLENTRY(JTAG_RTCK, "ae3", NULL),
	_OMAP4_BALLENTRY(JTAG_TMS_TMSC, "ah1", NULL),
	_OMAP4_BALLENTRY(JTAG_TDI, "ae1", NULL),
	_OMAP4_BALLENTRY(JTAG_TDO, "ae2", NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#else
#define omap4_wkup_cbl_cbs_ball  NULL
#endif

int __init omap4_mux_init(struct omap_board_mux *board_subset, int flags)
{
	struct omap_ball *package_balls_core;
	struct omap_ball *package_balls_wkup = omap4_wkup_cbl_cbs_ball;
	struct omap_mux *core_muxmodes;
	int ret;

	switch (flags & OMAP_PACKAGE_MASK) {
	case OMAP_PACKAGE_CBL:
		pr_debug("%s: OMAP4430 ES1.0 -> OMAP_PACKAGE_CBL\n", __func__);
		package_balls_core = omap4_core_cbl_ball;
		core_muxmodes = omap4_core_muxmodes;
		break;
	case OMAP_PACKAGE_CBS:
		pr_debug("%s: OMAP4430 ES2.X -> OMAP_PACKAGE_CBS\n", __func__);
		package_balls_core = omap4_core_cbs_ball;
		core_muxmodes = omap4_es2_core_muxmodes;
		break;
	default:
		pr_err("%s: Unknown omap package, mux disabled\n", __func__);
		return -EINVAL;
	}

	ret = omap_mux_init("core",
			    OMAP_MUX_GPIO_IN_MODE3,
			    OMAP4_CTRL_MODULE_PAD_CORE_MUX_PBASE,
			    OMAP4_CTRL_MODULE_PAD_CORE_MUX_SIZE,
			    core_muxmodes, NULL, board_subset,
			    package_balls_core);
	if (ret)
		return ret;

	ret = omap_mux_init("wkup",
			    OMAP_MUX_GPIO_IN_MODE3,
			    OMAP4_CTRL_MODULE_PAD_WKUP_MUX_PBASE,
			    OMAP4_CTRL_MODULE_PAD_WKUP_MUX_SIZE,
			    omap4_wkup_muxmodes, NULL, board_subset,
			    package_balls_wkup);

	return ret;
}

