/*
 * Copyright (C) 2005 - 2008 ServerEngines
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.  The full GNU General
 * Public License is included in this distribution in the file called COPYING.
 *
 * Contact Information:
 * linux-drivers@serverengines.com
 *
 * ServerEngines
 * 209 N. Fair Oaks Ave
 * Sunnyvale, CA 94085
 */
/*
 * Autogenerated by srcgen version: 0127
 */
#ifndef __be_cm_amap_h__
#define __be_cm_amap_h__
#include "be_common.h"
#include "etx_context.h"
#include "mpu_context.h"

/*
 * --- CEV_WATERMARK_ENUM ---
 * CQ/EQ Watermark Encodings. Encoded as number of free entries in
 * Queue when Watermark is reached.
 */
#define CEV_WMARK_0        (0)	/* Watermark when Queue full */
#define CEV_WMARK_16       (1)	/* Watermark at 16 free entries */
#define CEV_WMARK_32       (2)	/* Watermark at 32 free entries */
#define CEV_WMARK_48       (3)	/* Watermark at 48 free entries */
#define CEV_WMARK_64       (4)	/* Watermark at 64 free entries */
#define CEV_WMARK_80       (5)	/* Watermark at 80 free entries */
#define CEV_WMARK_96       (6)	/* Watermark at 96 free entries */
#define CEV_WMARK_112      (7)	/* Watermark at 112 free entries */
#define CEV_WMARK_128      (8)	/* Watermark at 128 free entries */
#define CEV_WMARK_144      (9)	/* Watermark at 144 free entries */
#define CEV_WMARK_160      (10)	/* Watermark at 160 free entries */
#define CEV_WMARK_176      (11)	/* Watermark at 176 free entries */
#define CEV_WMARK_192      (12)	/* Watermark at 192 free entries */
#define CEV_WMARK_208      (13)	/* Watermark at 208 free entries */
#define CEV_WMARK_224      (14)	/* Watermark at 224 free entries */
#define CEV_WMARK_240      (15)	/* Watermark at 240 free entries */

/*
 * --- CQ_CNT_ENUM ---
 * Completion Queue Count Encodings.
 */
#define CEV_CQ_CNT_256                  (0)	/* CQ has 256 entries */
#define CEV_CQ_CNT_512                  (1)	/* CQ has 512 entries */
#define CEV_CQ_CNT_1024                 (2)	/* CQ has 1024 entries */

/*
 * --- EQ_CNT_ENUM ---
 * Event Queue Count Encodings.
 */
#define CEV_EQ_CNT_256     (0)	/* EQ has 256 entries (16-byte EQEs only) */
#define CEV_EQ_CNT_512     (1)	/* EQ has 512 entries (16-byte EQEs only) */
#define CEV_EQ_CNT_1024    (2)	/* EQ has 1024 entries (4-byte or */
				/* 16-byte EQEs only) */
#define CEV_EQ_CNT_2048    (3)	/* EQ has 2048 entries (4-byte or */
				/* 16-byte EQEs only) */
#define CEV_EQ_CNT_4096    (4)	/* EQ has 4096 entries (4-byte EQEs only) */

/*
 * --- EQ_SIZE_ENUM ---
 * Event Queue Entry Size Encoding.
 */
#define CEV_EQ_SIZE_4                   (0)	/* EQE is 4 bytes */
#define CEV_EQ_SIZE_16                  (1)	/* EQE is 16 bytes */

/*
 * Completion Queue Context Table Entry. Contains the state of a CQ.
 * Located in RAM within the CEV block.
 */
struct BE_CQ_CONTEXT_AMAP {
	u8 Cidx[11];	/* DWORD 0 */
	u8 Watermark[4];	/* DWORD 0 */
	u8 NoDelay;		/* DWORD 0 */
	u8 EPIdx[11];	/* DWORD 0 */
	u8 Count[2];	/* DWORD 0 */
	u8 valid;		/* DWORD 0 */
	u8 SolEvent;	/* DWORD 0 */
	u8 Eventable;	/* DWORD 0 */
	u8 Pidx[11];	/* DWORD 1 */
	u8 PD[10];		/* DWORD 1 */
	u8 EQID[7];		/* DWORD 1 */
	u8 Func;		/* DWORD 1 */
	u8 WME;		/* DWORD 1 */
	u8 Stalled;		/* DWORD 1 */
	u8 Armed;		/* DWORD 1 */
} __packed;
struct CQ_CONTEXT_AMAP {
	u32 dw[2];
};

/*
 * Event Queue Context Table Entry. Contains the state of an EQ.
 * Located in RAM in the CEV block.
 */
struct BE_EQ_CONTEXT_AMAP {
	u8 Cidx[13];	/* DWORD 0 */
	u8 rsvd0[2];	/* DWORD 0 */
	u8 Func;		/* DWORD 0 */
	u8 EPIdx[13];	/* DWORD 0 */
	u8 valid;		/* DWORD 0 */
	u8 rsvd1;		/* DWORD 0 */
	u8 Size;		/* DWORD 0 */
	u8 Pidx[13];	/* DWORD 1 */
	u8 rsvd2[3];	/* DWORD 1 */
	u8 PD[10];		/* DWORD 1 */
	u8 Count[3];	/* DWORD 1 */
	u8 SolEvent;	/* DWORD 1 */
	u8 Stalled;		/* DWORD 1 */
	u8 Armed;		/* DWORD 1 */
	u8 Watermark[4];	/* DWORD 2 */
	u8 WME;		/* DWORD 2 */
	u8 rsvd3[3];	/* DWORD 2 */
	u8 EventVect[6];	/* DWORD 2 */
	u8 rsvd4[2];	/* DWORD 2 */
	u8 Delay[8];	/* DWORD 2 */
	u8 rsvd5[6];	/* DWORD 2 */
	u8 TMR;		/* DWORD 2 */
	u8 rsvd6;		/* DWORD 2 */
	u8 rsvd7[32];	/* DWORD 3 */
} __packed;
struct EQ_CONTEXT_AMAP {
	u32 dw[4];
};

#endif /* __be_cm_amap_h__ */
